/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collector;

import com.sap.jvm.profiling.snapshot.impl.tree.TreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeBaseImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.Pruner;
import com.sap.jvm.profiling.snapshot.util.Value;

public class ValueTreeCollector<K, V extends Value<V>>
extends TreeCollector<K, V, ValueTreeNodeImpl<K, V>> {
    private Pruner<V> treePruner;
    private V total;

    public ValueTreeCollector(V value) {
        this.total = value;
    }

    public void add(V value) {
        this.total = this.total.getSum(value);
    }

    public V getTotal() {
        return this.total;
    }

    @Override
    public void add(ValueTreeCollector<K, V> other, ValueTreeNodeImpl<K, V> startNode) {
        super.addImpl(other, startNode);
        this.total = this.total.getSum(other.total);
    }

    @Override
    protected void add(ValueTreeNodeImpl<K, V> base, ValueTreeNodeImpl<K, V> toAdd) {
        base.addValue(toAdd.getValue());
    }

    @Override
    protected boolean shouldPrune(ValueTreeNodeImpl<K, V> node) {
        if (this.treePruner == null) {
            return false;
        }
        ValueTreeNodeImpl parent = (ValueTreeNodeImpl)node.getParent();
        if (parent == null) {
            return false;
        }
        return this.treePruner.shouldPrune(node.getValue(), parent.getValue(), this.total);
    }

    @Override
    protected ValueTreeNodeBaseImpl<K, V>[] createArray(int size) {
        return new ValueTreeNodeImpl[size];
    }

    public void prune(Pruner<V> pruner, int startDepth) {
        if (pruner != null) {
            this.treePruner = pruner;
            this.prune(startDepth);
        }
    }
}

