/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjectsColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class BytesAndObjectsColumnImpl
extends LongColumnBase
implements SerializableColumn<BytesAndObjects>,
BytesAndObjectsColumn {
    private static final int VERSION = 3;
    private static final int BYTE_COLUMN = 0;
    private static final int OBJECTS_COLUMN = 1;
    private static final int HEAP_BYTE_COLUMN = 2;
    private static final int HEAP_OBJECTS_COLUMN = 3;
    private static final int STACK_BYTE_COLUMN = 4;
    private static final int STACK_OBJECTS_COLUMN = 5;
    private final LongValueColumnImpl bytesColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl objectsColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl heapBytesColumn = new LongValueColumnImpl(this, 2);
    private final LongValueColumnImpl heapObjectsColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl stackBytesColumn = new LongValueColumnImpl(this, 4);
    private final LongValueColumnImpl stackObjectsColumn = new LongValueColumnImpl(this, 5);

    public BytesAndObjectsColumnImpl() {
        super(6);
    }

    @Override
    public void fromList(List<BytesAndObjects> list) {
        int i;
        int nrOfRows = list.size();
        long[][] value = this.setNrOfRows(nrOfRows);
        value[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[0][i] = list.get(i).getBytes();
        }
        this.convertColumnIfPossible(0);
        value[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[1][i] = list.get(i).getObjects();
        }
        this.convertColumnIfPossible(1);
        value[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[2][i] = list.get(i).getHeapBytes();
        }
        this.convertColumnIfPossible(2);
        value[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[3][i] = list.get(i).getHeapObjects();
        }
        this.convertColumnIfPossible(3);
        value[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[4][i] = list.get(i).getStackBytes();
        }
        this.convertColumnIfPossible(4);
        value[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[5][i] = list.get(i).getStackObjects();
        }
        this.convertColumnIfPossible(5);
    }

    @Override
    public BytesAndObjects get(int index) {
        return new BytesAndObjects(this.getValue(2, index), this.getValue(3, index), this.getValue(4, index), this.getValue(5, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(3);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(3);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getBytesColumn() {
        return this.bytesColumn;
    }

    @Override
    public LongValueColumn getObjectsColumn() {
        return this.objectsColumn;
    }

    @Override
    public LongValueColumn getHeapBytesColumn() {
        return this.heapBytesColumn;
    }

    @Override
    public LongValueColumn getHeapObjectsColumn() {
        return this.heapObjectsColumn;
    }

    @Override
    public LongValueColumn getStackBytesColumn() {
        return this.stackBytesColumn;
    }

    @Override
    public LongValueColumn getStackObjectsColumn() {
        return this.stackObjectsColumn;
    }
}

