/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.UniqueSortableColumn;
import java.io.IOException;
import java.util.List;

public class ClassColumn
extends LongColumnBase
implements SerializableColumn<ClassObject>,
UniqueSortableColumn {
    private static final int VERSION = 1;
    private final ClassObjectManager manager;

    public ClassColumn(ProfilingSession session) {
        super(1);
        this.manager = session.getClassObjectManager();
    }

    @Override
    public void fromList(List<ClassObject> list) {
        int nrOfRows = list.size();
        long[][] value = this.setNrOfRows(nrOfRows);
        value[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            value[0][i] = list.get(i).getIndex();
        }
        this.convertColumnIfPossible(0);
    }

    @Override
    public ClassObject get(int index) {
        return this.manager.getClassObject((int)this.getValue(0, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
    }

    @Override
    public int[] sortUnique(int[] initialOrder, int nrOfThreads) {
        return this.sortAscending(initialOrder, 0, nrOfThreads);
    }
}

