/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class ClassLoaderColumn
implements SerializableColumn<ClassLoaderObject> {
    private static final int VERSION = 0;
    private ClassLoaderObject[] loaders = new ClassLoaderObject[0];

    @Override
    public void fromList(List<ClassLoaderObject> list) {
        this.loaders = list.toArray(new ClassLoaderObject[list.size()]);
    }

    @Override
    public ClassLoaderObject get(int index) {
        return this.loaders[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.loaders = new ClassLoaderObject[reader.readInt32()];
        for (int i = 0; i < this.loaders.length; ++i) {
            reporter.reportNextOrThrow();
            this.loaders[i] = reader.readClassLoaderObject();
        }
    }

    @Override
    public int size() {
        return this.loaders.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.loaders.length);
        for (ClassLoaderObject loader : this.loaders) {
            reporter.reportNextOrThrow();
            writer.writeClassLoaderObject(loader);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

