/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.cls.ClassLoaderValue;
import com.sap.jvm.profiling.snapshot.impl.cls.ClassLoaderValueImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class ClassLoaderValueColumn
implements SerializableColumn<ClassLoaderValue> {
    private static final int VERSION = 0;
    private ClassLoaderValue[] loaders = new ClassLoaderValue[0];

    @Override
    public void fromList(List<ClassLoaderValue> list) {
        this.loaders = list.toArray(new ClassLoaderValue[list.size()]);
    }

    @Override
    public ClassLoaderValue get(int index) {
        return this.loaders[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.loaders = new ClassLoaderValue[reader.readInt32()];
        for (int i = 0; i < this.loaders.length; ++i) {
            reporter.reportNextOrThrow();
            this.loaders[i] = new ClassLoaderValueImpl(reader);
        }
    }

    @Override
    public int size() {
        return this.loaders.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.loaders.length);
        for (ClassLoaderValue loader : this.loaders) {
            reporter.reportNextOrThrow();
            ((ClassLoaderValueImpl)loader).write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

