/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.mpt.CpuAndElapsedTime;
import com.sap.jvm.profiling.snapshot.mpt.CpuAndElapsedTimeColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class CpuAndElapsedTimeColumnImpl
extends LongColumnBase
implements CpuAndElapsedTimeColumn,
SerializableColumn<CpuAndElapsedTime> {
    private static final int VERSION = 2;
    private static int ELAPSED_TIME_COLUMN = 0;
    private static int CPUI_TIME_COLUMN = 1;
    private final LongValueColumnImpl cpuTimeColumn = new LongValueColumnImpl(this, CPUI_TIME_COLUMN);
    private final LongValueColumnImpl elapsedTimeColumn = new LongValueColumnImpl(this, ELAPSED_TIME_COLUMN);

    public CpuAndElapsedTimeColumnImpl() {
        super(2);
    }

    @Override
    public void fromList(List<CpuAndElapsedTime> list) {
        int i;
        int nrOfRows = list.size();
        long[][] value = this.setNrOfRows(nrOfRows);
        value[CpuAndElapsedTimeColumnImpl.ELAPSED_TIME_COLUMN] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[CpuAndElapsedTimeColumnImpl.ELAPSED_TIME_COLUMN][i] = list.get(i).getElapsedTime();
        }
        this.convertColumnIfPossible(ELAPSED_TIME_COLUMN);
        value[CpuAndElapsedTimeColumnImpl.CPUI_TIME_COLUMN] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            value[CpuAndElapsedTimeColumnImpl.CPUI_TIME_COLUMN][i] = list.get(i).getCpuTime();
        }
        this.convertColumnIfPossible(CPUI_TIME_COLUMN);
    }

    @Override
    public CpuAndElapsedTime get(int index) {
        return CpuAndElapsedTime.create(this.getValue(CPUI_TIME_COLUMN, index), this.getValue(ELAPSED_TIME_COLUMN, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getCpuTimeColumn() {
        return this.cpuTimeColumn;
    }

    @Override
    public LongValueColumn getElapsedTimeColumn() {
        return this.elapsedTimeColumn;
    }
}

