/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.resource.FileId;
import java.io.IOException;
import java.util.List;

public class FileIdColumn
implements SerializableColumn<FileId> {
    private static final int VERSION = 0;
    private FileId[] fileIds = new FileId[0];

    @Override
    public void fromList(List<FileId> list) {
        this.fileIds = list.toArray(new FileId[list.size()]);
    }

    @Override
    public FileId get(int index) {
        return this.fileIds[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.fileIds = new FileId[reader.readInt32()];
        for (int i = 0; i < this.fileIds.length; ++i) {
            reporter.reportNextOrThrow();
            this.fileIds[i] = new FileId(reader);
        }
    }

    @Override
    public int size() {
        return this.fileIds.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.fileIds.length);
        for (FileId fileId : this.fileIds) {
            reporter.reportNextOrThrow();
            fileId.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

