/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class FilterEntityColumn
implements SerializableColumn<FilterEntity> {
    private static final int VERSION = 0;
    private FilterEntity[] entities = new FilterEntity[0];

    @Override
    public void fromList(List<FilterEntity> list) {
        this.entities = list.toArray(new FilterEntity[list.size()]);
    }

    @Override
    public FilterEntity get(int index) {
        return this.entities[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.entities = new FilterEntity[reader.readInt32()];
        for (int i = 0; i < this.entities.length; ++i) {
            reporter.reportNextOrThrow();
            this.entities[i] = new FilterEntity(reader);
        }
    }

    @Override
    public int size() {
        return this.entities.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.entities.length);
        for (FilterEntity entity : this.entities) {
            reporter.reportNextOrThrow();
            entity.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

