/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValuesColumn;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValuesColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.GcStatisticValuesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.LongArrayColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.util.column.Column;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GcEventStatisticValuesColumnImpl
extends LongColumnBase
implements SerializableColumn<GcEventStatisticValue>,
GcEventStatisticValuesColumn {
    private static final int VERSION = 1;
    private final List<GcEventStatisticValueElement> valueElements;
    private Column[] columns;
    private GcStatisticValuesColumnImpl statisticColumn;

    public GcEventStatisticValuesColumnImpl(List<GcEventStatisticValueElement> valueElements) {
        super(valueElements.size());
        this.valueElements = valueElements;
        this.statisticColumn = new GcStatisticValuesColumnImpl();
        this.columns = new Column[valueElements.size()];
        block5: for (int i = 0; i < valueElements.size(); ++i) {
            switch (valueElements.get(i).getType()) {
                case 2: {
                    this.columns[i] = new UTF8StringColumn();
                    continue block5;
                }
                case 0: 
                case 1: {
                    this.columns[i] = new LongValueColumnImpl(this, i);
                    continue block5;
                }
                case 3: {
                    this.columns[i] = new LongArrayColumn();
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
    }

    @Override
    public GcEventStatisticValue get(int index) {
        Object[] valueData = new Object[this.valueElements.size()];
        block5: for (int colIdx = 0; colIdx < this.valueElements.size(); ++colIdx) {
            switch (this.valueElements.get(colIdx).getType()) {
                case 2: {
                    valueData[colIdx] = ((UTF8StringColumn)this.columns[colIdx]).get(index).toString();
                    continue block5;
                }
                case 0: 
                case 1: {
                    valueData[colIdx] = this.getValue(colIdx, index);
                    continue block5;
                }
                case 3: {
                    valueData[colIdx] = ((LongArrayColumn)this.columns[colIdx]).get(index);
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return new GcEventStatisticValue(this.valueElements, valueData, this.statisticColumn.get(index));
    }

    @Override
    public Column getColumn(GcEventStatisticValueElement element) {
        return this.getColumn(this.valueElements.indexOf(element));
    }

    @Override
    public Column getColumn(int columnIdx) {
        return this.columns[columnIdx];
    }

    @Override
    public void fromList(List<GcEventStatisticValue> list) {
        int nrOfRows = list.size();
        ArrayList<GcStatisticValue> statisticList = new ArrayList<GcStatisticValue>(nrOfRows);
        for (GcEventStatisticValue event : list) {
            statisticList.add(event.getGcStatisticData());
        }
        this.statisticColumn.fromList((List<GcStatisticValue>)statisticList);
        long[][] values = this.setNrOfRows(nrOfRows);
        block6: for (int colId = 0; colId < this.valueElements.size(); ++colId) {
            GcEventStatisticValueElement element = this.valueElements.get(colId);
            switch (element.getType()) {
                case 2: {
                    UTF8String[] stringsList = new UTF8String[nrOfRows];
                    for (int i = 0; i < nrOfRows; ++i) {
                        String valString = (String)list.get(i).getElementValue(element);
                        stringsList[i] = UTF8Creator.create((String)valString);
                    }
                    UTF8StringColumn strColumn = (UTF8StringColumn)this.columns[colId];
                    strColumn.setList(stringsList);
                    continue block6;
                }
                case 0: 
                case 1: {
                    values[colId] = new long[nrOfRows];
                    for (int i = 0; i < nrOfRows; ++i) {
                        values[colId][i] = (Long)list.get(i).getElementValue(element);
                    }
                    this.convertColumnIfPossible(colId);
                    continue block6;
                }
                case 3: {
                    long[][] valuesList = new long[nrOfRows][];
                    for (int i = 0; i < nrOfRows; ++i) {
                        valuesList[i] = (long[])list.get(i).getElementValue(element);
                    }
                    LongArrayColumn arrColumn = (LongArrayColumn)this.columns[colId];
                    arrColumn.setList(valuesList);
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + this.statisticColumn.getWork(size);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.statisticColumn.read(reader, reporter);
        this.readColumns(reader, reporter);
        block4: for (int i = 0; i < this.valueElements.size(); ++i) {
            switch (this.valueElements.get(i).getType()) {
                case 3: {
                    ((LongArrayColumn)this.columns[i]).read(reader, reporter);
                    continue block4;
                }
                case 2: {
                    ((UTF8StringColumn)this.columns[i]).read(reader, reporter);
                    continue block4;
                }
            }
        }
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.statisticColumn.write(writer, reporter);
        this.writeColumns(writer, reporter);
        block4: for (int i = 0; i < this.valueElements.size(); ++i) {
            switch (this.valueElements.get(i).getType()) {
                case 3: {
                    ((LongArrayColumn)this.columns[i]).write(writer, reporter);
                    continue block4;
                }
                case 2: {
                    ((UTF8StringColumn)this.columns[i]).write(writer, reporter);
                    continue block4;
                }
            }
        }
    }

    @Override
    public GcStatisticValuesColumn getStatisticValuesColumn() {
        return this.statisticColumn;
    }
}

