/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValuesColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class GcStatisticValuesColumnImpl
extends LongColumnBase
implements SerializableColumn<GcStatisticValue>,
GcStatisticValuesColumn {
    private static final int VERSION = 2;
    private static final int NR_OF_COLUMNS = GcStatisticValueElement.values().length;
    private LongValueColumnImpl[] columns = new LongValueColumnImpl[NR_OF_COLUMNS];

    public GcStatisticValuesColumnImpl() {
        super(NR_OF_COLUMNS);
        for (int i = 0; i < NR_OF_COLUMNS; ++i) {
            this.columns[i] = new LongValueColumnImpl(this, i);
        }
    }

    @Override
    public GcStatisticValue get(int index) {
        long[] valueData = new long[NR_OF_COLUMNS];
        for (int colIdx = 0; colIdx < NR_OF_COLUMNS; ++colIdx) {
            valueData[colIdx] = this.getValue(colIdx, index);
        }
        return new GcStatisticValue(valueData);
    }

    @Override
    public LongValueColumn getColumn(GcStatisticValueElement element) {
        return this.getColumn(element.ordinal());
    }

    @Override
    public LongValueColumn getColumn(int columnIdx) {
        return this.columns[columnIdx];
    }

    @Override
    public void fromList(List<GcStatisticValue> list) {
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        for (int colId = 0; colId < NR_OF_COLUMNS; ++colId) {
            values[colId] = new long[nrOfRows];
            for (int i = 0; i < nrOfRows; ++i) {
                values[colId][i] = list.get(i).getElementValue(colId);
            }
            this.convertColumnIfPossible(colId);
        }
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        this.writeColumns(writer, reporter);
    }
}

