/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.io.IODetails;
import com.sap.jvm.profiling.snapshot.io.IODetailsColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class IODetailsColumnImpl
extends LongColumnBase
implements SerializableColumn<IODetails>,
IODetailsColumn {
    private static final int VERSION = 1;
    private static final int FD_COLUMN = 0;
    private static final int OPEN_TIMESTAMP_COLUMN = 1;
    private static final int OPENING_THREAD_ID_COLUMN = 2;
    private static final int CLOSE_TIMESTAMP_COLUMN = 3;
    private static final int CLOSING_THREAD_ID_COLUMN = 4;
    private static final int NR_OF_COLUMNS = 5;
    private final LongValueColumnImpl fdColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl openTimestampColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl closeTimestampColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl openingThreadIdColumn = new LongValueColumnImpl(this, 2);
    private final UTF8StringColumn openingThreadNameColumn;
    private final LongValueColumnImpl closingThreadIdColumn = new LongValueColumnImpl(this, 4);
    private final UTF8StringColumn closingThreadNameColumn;

    public IODetailsColumnImpl() {
        super(5);
        this.openingThreadNameColumn = new UTF8StringColumn();
        this.closingThreadNameColumn = new UTF8StringColumn();
    }

    @Override
    public void fromList(List<IODetails> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getFd();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getOpenTimestamp();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getOpeningThreadId();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[3][i] = list.get(i).getCloseTimestamp();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[4][i] = list.get(i).getClosingThreadId();
        }
        this.convertColumnIfPossible(4);
        UTF8String[] openingNames = new UTF8String[nrOfRows];
        UTF8String[] closingNames = new UTF8String[nrOfRows];
        for (int i2 = 0; i2 < nrOfRows; ++i2) {
            openingNames[i2] = list.get(i2).getOpeningThreadName();
            closingNames[i2] = list.get(i2).getClosingThreadName();
        }
        this.openingThreadNameColumn.setList(openingNames);
        this.closingThreadNameColumn.setList(closingNames);
    }

    @Override
    public IODetails get(int index) {
        return new IODetails(this.getValue(0, index), this.getValue(1, index), this.getValue(2, index), this.openingThreadNameColumn.get(index), this.getValue(3, index), this.getValue(4, index), this.closingThreadNameColumn.get(index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.openingThreadNameColumn.read(reader, reporter);
        this.closingThreadNameColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.openingThreadNameColumn.write(writer, reporter);
        this.closingThreadNameColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + 2L * this.openingThreadNameColumn.getWork(size);
    }

    @Override
    public LongValueColumn getCloseTimestampColumn() {
        return this.closeTimestampColumn;
    }

    @Override
    public LongValueColumn getClosingThreadIdColumn() {
        return this.closingThreadIdColumn;
    }

    @Override
    public UTF8StringColumn getClosingThreadNameColumn() {
        return this.closingThreadNameColumn;
    }

    @Override
    public LongValueColumn getFdColumn() {
        return this.fdColumn;
    }

    @Override
    public LongValueColumn getOpenTimestampColumn() {
        return this.openTimestampColumn;
    }

    @Override
    public LongValueColumn getOpeningThreadIdColumn() {
        return this.openingThreadIdColumn;
    }

    @Override
    public UTF8StringColumn getOpeningThreadNameColumn() {
        return this.openingThreadNameColumn;
    }
}

