/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetailsColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class IOOperationsAndDetailsColumnImpl
extends LongColumnBase
implements SerializableColumn<IOOperationsAndDetails>,
IOOperationsAndDetailsColumn {
    private static final long INVALID = 0L;
    private static final int VERSION = 1;
    private static final int FD_COLUMN = 0;
    private static final int OPEN_TIMESTAMP_COLUMN = 1;
    private static final int OPENING_THREAD_ID_COLUMN = 2;
    private static final int CLOSE_TIMESTAMP_COLUMN = 3;
    private static final int CLOSING_THREAD_ID_COLUMN = 4;
    private static final int READ_OPERATIONS_COLUMN = 5;
    private static final int WRITE_OPERATIONS_COLUMN = 6;
    private static final int READ_TIME_COLUMN = 7;
    private static final int WRITE_TIME_COLUMN = 8;
    private static final int READ_BYTES_COLUMN = 9;
    private static final int WRITTEN_BYTES_COLUMN = 10;
    private static final int NR_OF_COLUMNS = 11;
    private final LongValueColumnImpl fdColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl openTimestampColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl closeTimestampColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl openingThreadIdColumn = new LongValueColumnImpl(this, 2);
    private final UTF8StringColumn openingThreadNameColumn;
    private final LongValueColumnImpl closingThreadIdColumn = new LongValueColumnImpl(this, 4);
    private final UTF8StringColumn closingThreadNameColumn;
    private final LongValueColumnImpl readOperationsColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl writeOperationsColumn = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl readTimeColumn = new LongValueColumnImpl(this, 7);
    private final LongValueColumnImpl writeTimeColumn = new LongValueColumnImpl(this, 8);
    private final LongValueColumnImpl readBytesColumn = new LongValueColumnImpl(this, 9);
    private final LongValueColumnImpl writtenBytesColumn = new LongValueColumnImpl(this, 10);

    public IOOperationsAndDetailsColumnImpl() {
        super(11);
        this.openingThreadNameColumn = new UTF8StringColumn();
        this.closingThreadNameColumn = new UTF8StringColumn();
    }

    @Override
    public void fromList(List<IOOperationsAndDetails> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getFd();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getOpenTimestamp();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getOpeningThreadId();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[3][i] = list.get(i).getCloseTimestamp();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[4][i] = list.get(i).getClosingThreadId();
        }
        this.convertColumnIfPossible(4);
        values[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[5][i] = list.get(i).getReadOperations();
        }
        this.convertColumnIfPossible(5);
        values[6] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[6][i] = list.get(i).getWriteOperations();
        }
        this.convertColumnIfPossible(6);
        values[7] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[7][i] = list.get(i).getReadTime();
        }
        this.convertColumnIfPossible(7);
        values[8] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[8][i] = list.get(i).getWriteTime();
        }
        this.convertColumnIfPossible(8);
        values[9] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[9][i] = list.get(i).getReadBytes();
        }
        this.convertColumnIfPossible(9);
        values[10] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[10][i] = list.get(i).getWrittenBytes();
        }
        this.convertColumnIfPossible(10);
        UTF8String[] openingNames = new UTF8String[nrOfRows];
        UTF8String[] closingNames = new UTF8String[nrOfRows];
        for (int i2 = 0; i2 < nrOfRows; ++i2) {
            openingNames[i2] = list.get(i2).getOpeningThreadName();
            closingNames[i2] = list.get(i2).getClosingThreadName();
        }
        this.openingThreadNameColumn.setList(openingNames);
        this.closingThreadNameColumn.setList(closingNames);
    }

    @Override
    public IOOperationsAndDetails get(int index) {
        return new IOOperationsAndDetails(this.getValue(0, index), this.getValue(1, index), this.getValue(2, index), this.openingThreadNameColumn.get(index), this.getValue(3, index), this.getValue(4, index), this.closingThreadNameColumn.get(index), this.getValue(9, index), this.getValue(10, index), this.getValue(7, index), this.getValue(8, index), this.getValue(5, index), this.getValue(6, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.openingThreadNameColumn.read(reader, reporter);
        this.closingThreadNameColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.openingThreadNameColumn.write(writer, reporter);
        this.closingThreadNameColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + 2L * this.openingThreadNameColumn.getWork(size);
    }

    @Override
    public LongValueColumn getCloseTimestampColumn() {
        return this.closeTimestampColumn;
    }

    @Override
    public LongValueColumn getClosingThreadIdColumn() {
        return this.closingThreadIdColumn;
    }

    @Override
    public UTF8StringColumn getClosingThreadNameColumn() {
        return this.closingThreadNameColumn;
    }

    @Override
    public LongValueColumn getFdColumn() {
        return this.fdColumn;
    }

    @Override
    public LongValueColumn getOpenTimestampColumn() {
        return this.openTimestampColumn;
    }

    @Override
    public LongValueColumn getOpeningThreadIdColumn() {
        return this.openingThreadIdColumn;
    }

    @Override
    public UTF8StringColumn getOpeningThreadNameColumn() {
        return this.openingThreadNameColumn;
    }

    @Override
    public LongValueColumn getReadBytesColumn() {
        return this.readBytesColumn;
    }

    @Override
    public LongValueColumn getReadOperationsColumn() {
        return this.readOperationsColumn;
    }

    @Override
    public LongValueColumn getReadTimeColumn() {
        return this.readTimeColumn;
    }

    @Override
    public LongValueColumn getWriteOperationsColumn() {
        return this.writeOperationsColumn;
    }

    @Override
    public LongValueColumn getWriteTimeColumn() {
        return this.writeTimeColumn;
    }

    @Override
    public LongValueColumn getWrittenBytesColumn() {
        return this.writtenBytesColumn;
    }

    @Override
    public LongValueColumn getReadBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(5, i);
            values[0][i] = div == 0L ? 0L : this.getValue(9, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getReadTroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(7, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(9, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerReadOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(5, i);
            values[0][i] = div == 0L ? 0L : this.getValue(7, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerWriteOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(6, i);
            values[0][i] = div == 0L ? 0L : this.getValue(8, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWriteThroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(8, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(10, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWrittenBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(6, i);
            values[0][i] = div == 0L ? 0L : this.getValue(10, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }
}

