/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.util.pair.IntPair;
import java.io.IOException;
import java.util.List;

public class IntPairColumn
implements SerializableColumn<IntPair> {
    private static final int VERSION = 0;
    private int[] firsts = new int[0];
    private int[] seconds = this.firsts;

    @Override
    public void fromList(List<IntPair> list) {
        this.firsts = new int[list.size()];
        this.seconds = new int[list.size()];
        for (int i = 0; i < this.firsts.length; ++i) {
            this.firsts[i] = list.get(i).getFirst();
            this.seconds[i] = list.get(i).getSecond();
        }
    }

    @Override
    public IntPair get(int index) {
        return new IntPair(this.firsts[index], this.seconds[index]);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.firsts = new int[reader.readInt32()];
        this.seconds = new int[this.firsts.length];
        for (int i = 0; i < this.firsts.length; ++i) {
            reporter.reportNextOrThrow();
            this.firsts[i] = reader.readInt32();
            this.seconds[i] = reader.readInt32();
        }
    }

    @Override
    public int size() {
        return this.firsts.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.firsts.length);
        for (int i = 0; i < this.firsts.length; ++i) {
            reporter.reportNextOrThrow();
            writer.writeInt32(this.firsts[i]);
            writer.writeInt32(this.seconds[i]);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

