/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class IntegerColumn
implements SerializableColumn<Integer> {
    private static final int VERSION = 0;
    private int[] values = new int[0];

    @Override
    public void fromList(List<Integer> list) {
        this.values = new int[list.size()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = list.get(i);
        }
    }

    @Override
    public Integer get(int index) {
        return this.values[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.values = new int[reader.readInt32()];
        for (int i = 0; i < this.values.length; ++i) {
            reporter.reportNextOrThrow();
            this.values[i] = reader.readInt32();
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            reporter.reportNextOrThrow();
            writer.writeInt32(this.values[i]);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

