/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TotalLongValueColumn;
import com.sap.jvm.profiling.snapshot.mpt.InvocationDistColumn;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.resource.SimpleInvocationDist;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class InvocationDistColumnImpl
extends LongColumnBase
implements SerializableColumn<InvocationDist>,
InvocationDistColumn {
    private static final int VERSION = 2;
    private static final int INTERPRETER_INVOCATIONS = 0;
    private static final int NATIVE_INTERPRETER_INVOCATIONS = 1;
    private static final int INLINED_INVOCATIONS = 2;
    private static final int NATIVE_INLINED_INVOCATIONS = 3;
    private static final int COMPILED_INVOCATIONS = 4;
    private static final int NATIVE_COMPILED_INVOCATIONS = 5;
    private static final int INLINED_TIER_1_INVOCATIONS = 6;
    private static final int NATIVE_INLINED_TIER_1_INVOCATIONS = 7;
    private static final int COMPILED_TIER_1_INVOCATIONS = 8;
    private static final int NATIVE_COMPILED_TIER_1_INVOCATIONS = 9;
    private static final int OTHER_INVOCATIONS = 10;
    private static final int NR_OF_COLUMNS = 11;
    private final LongValueColumnImpl interpreterInvocationsColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl nativeInterpreterInvocationsColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl inlinedInvocationsColumn = new LongValueColumnImpl(this, 2);
    private final LongValueColumnImpl nativeInlinedInvocationsColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl compiledInvocationsColumn = new LongValueColumnImpl(this, 4);
    private final LongValueColumnImpl nativeCompiledInvocationsColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl inlinedTier1InvocationsColumn = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl nativeInlinedTier1InvocationsColumn = new LongValueColumnImpl(this, 7);
    private final LongValueColumnImpl compiledTier1InvocationsColumn = new LongValueColumnImpl(this, 8);
    private final LongValueColumnImpl nativeCompiledTier1InvocationsColumn = new LongValueColumnImpl(this, 9);
    private final LongValueColumnImpl otherInvocationsColumn = new LongValueColumnImpl(this, 10);
    private final TotalLongValueColumn totalInvocationsColumn = new TotalLongValueColumn(this);

    public InvocationDistColumnImpl() {
        super(11);
    }

    @Override
    public void fromList(List<InvocationDist> list) {
        int i;
        int nrOfRows = list.size();
        long[][] invocations = this.setNrOfRows(nrOfRows);
        invocations[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[0][i] = list.get(i).getInterpreterInvocations();
        }
        this.convertColumnIfPossible(0);
        invocations[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[1][i] = list.get(i).getNativeInterpreterInvocations();
        }
        this.convertColumnIfPossible(1);
        invocations[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[2][i] = list.get(i).getInlinedInvocations();
        }
        this.convertColumnIfPossible(2);
        invocations[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[3][i] = list.get(i).getNativeInlinedInvocations();
        }
        this.convertColumnIfPossible(3);
        invocations[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[4][i] = list.get(i).getCompiledInvocations();
        }
        this.convertColumnIfPossible(4);
        invocations[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[5][i] = list.get(i).getNativeCompiledInvocations();
        }
        this.convertColumnIfPossible(5);
        invocations[6] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[6][i] = list.get(i).getInlinedTier1Invocations();
        }
        this.convertColumnIfPossible(6);
        invocations[7] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[7][i] = list.get(i).getNativeInlinedTier1Invocations();
        }
        this.convertColumnIfPossible(7);
        invocations[8] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[8][i] = list.get(i).getCompiledTier1Invocations();
        }
        this.convertColumnIfPossible(8);
        invocations[9] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[9][i] = list.get(i).getNativeCompiledTier1Invocations();
        }
        this.convertColumnIfPossible(9);
        invocations[10] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            invocations[10][i] = list.get(i).getOtherInvocations();
        }
        this.convertColumnIfPossible(10);
        this.createNonZeroColumnInfo();
    }

    @Override
    public InvocationDist get(int index) {
        return new ColumnInvocationDist(this, index);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getCompiledInvocationsColumn() {
        return this.compiledInvocationsColumn;
    }

    @Override
    public LongValueColumn getCompiledTier1InvocationsColumn() {
        return this.compiledTier1InvocationsColumn;
    }

    @Override
    public LongValueColumn getInlinedInvocationsColumn() {
        return this.inlinedInvocationsColumn;
    }

    @Override
    public LongValueColumn getInlinedTier1InvocationsColumn() {
        return this.inlinedTier1InvocationsColumn;
    }

    @Override
    public LongValueColumn getInterpreterInvocationsColumn() {
        return this.interpreterInvocationsColumn;
    }

    @Override
    public LongValueColumn getNativeCompiledInvocationsColumn() {
        return this.nativeCompiledInvocationsColumn;
    }

    @Override
    public LongValueColumn getNativeCompiledTier1InvocationsColumn() {
        return this.nativeCompiledTier1InvocationsColumn;
    }

    @Override
    public LongValueColumn getNativeInlinedInvocationsColumn() {
        return this.nativeInlinedInvocationsColumn;
    }

    @Override
    public LongValueColumn getNativeInlinedTier1InvocationsColumn() {
        return this.nativeInlinedTier1InvocationsColumn;
    }

    @Override
    public LongValueColumn getNativeInterpreterInvocationsColumn() {
        return this.nativeInterpreterInvocationsColumn;
    }

    @Override
    public LongValueColumn getOtherInvocationsColumn() {
        return this.otherInvocationsColumn;
    }

    @Override
    public LongValueColumn getTotalInvocationsColumn() {
        return this.totalInvocationsColumn;
    }

    private static final class ColumnInvocationDist
    implements InvocationDist {
        private final InvocationDistColumnImpl column;
        private final int row;

        public ColumnInvocationDist(InvocationDistColumnImpl column, int row) {
            this.column = column;
            this.row = row;
        }

        @Override
        public long getCompiledTier1Invocations() {
            return this.column.getValue(8, this.row);
        }

        @Override
        public long getCompiledInvocations() {
            return this.column.getValue(4, this.row);
        }

        @Override
        public long getInlinedTier1Invocations() {
            return this.column.getValue(6, this.row);
        }

        @Override
        public long getInlinedInvocations() {
            return this.column.getValue(2, this.row);
        }

        @Override
        public long getInterpreterInvocations() {
            return this.column.getValue(0, this.row);
        }

        @Override
        public long getNativeCompiledTier1Invocations() {
            return this.column.getValue(9, this.row);
        }

        @Override
        public long getNativeCompiledInvocations() {
            return this.column.getValue(5, this.row);
        }

        @Override
        public long getNativeInlinedTier1Invocations() {
            return this.column.getValue(7, this.row);
        }

        @Override
        public long getNativeInlinedInvocations() {
            return this.column.getValue(3, this.row);
        }

        @Override
        public long getNativeInterpreterInvocations() {
            return this.column.getValue(1, this.row);
        }

        @Override
        public long getOtherInvocations() {
            return this.column.getValue(10, this.row);
        }

        @Override
        public InvocationDist getSum(InvocationDist toAdd) {
            return new SimpleInvocationDist(this).getSum(toAdd);
        }

        @Override
        public long getTotalInvocations() {
            return this.column.getTotalValue(this.row);
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            new SimpleInvocationDist(this).write(writer);
        }
    }
}

