/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.InvocationDistColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.mpt.InvocationDistColumn;
import com.sap.jvm.profiling.snapshot.mpt.InvocationsAndTime;
import com.sap.jvm.profiling.snapshot.mpt.InvocationsAndTimeColumn;
import com.sap.jvm.profiling.snapshot.resource.InvocationDist;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InvocationsAndTimeColumnImpl
extends LongColumnBase
implements SerializableColumn<InvocationsAndTime>,
InvocationsAndTimeColumn {
    private static final int VERSION = 2;
    private static final int TIME_COLUMN = 0;
    private static final int CPU_TIME_COLUMN = 1;
    InvocationDistColumnImpl invocations = new InvocationDistColumnImpl();
    private final LongValueColumnImpl elapsedTimeColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl cpuTimeColumn = new LongValueColumnImpl(this, 1);

    public InvocationsAndTimeColumnImpl() {
        super(2);
    }

    @Override
    public void fromList(List<InvocationsAndTime> list) {
        int i;
        ArrayList<InvocationDist> invocationsList = new ArrayList<InvocationDist>(list.size());
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getElapsedTime();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getCpuTime();
        }
        this.convertColumnIfPossible(1);
        for (i = 0; i < nrOfRows; ++i) {
            invocationsList.add(list.get(i).getInvocations());
        }
        this.invocations = new InvocationDistColumnImpl();
        this.invocations.fromList((List<InvocationDist>)invocationsList);
    }

    @Override
    public InvocationsAndTime get(int index) {
        return new InvocationsAndTime(this.invocations.get(index), this.getValue(1, index), this.getValue(0, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.readColumns(reader, reporter);
        this.invocations.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        this.writeColumns(writer, reporter);
        this.invocations.write(writer, reporter);
    }

    @Override
    public LongValueColumn getCpuTimeColumn() {
        return this.cpuTimeColumn;
    }

    @Override
    public LongValueColumn getElapsedTimeColumn() {
        return this.elapsedTimeColumn;
    }

    @Override
    public InvocationDistColumn getInvocationDistColumn() {
        return this.invocations;
    }
}

