/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class LongArrayColumn
implements SerializableColumn<long[]> {
    private static final int VERSION = 0;
    private static final long[] EMPTY_ARRAY = new long[0];
    private long[][] values = new long[0][];

    @Override
    public void fromList(List<long[]> list) {
        this.values = (long[][])list.toArray((T[])new long[list.size()][]);
    }

    @Override
    public long[] get(int index) {
        if (this.values[index] == null) {
            return EMPTY_ARRAY;
        }
        return this.values[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        int i;
        int runLength;
        reader.readVersion(0);
        this.values = new long[reader.readInt32()][];
        for (i = 0; i < this.values.length; i += runLength) {
            runLength = reader.readInt8() & 0xFF;
            int arrayLength = reader.readInt32();
            if (arrayLength <= 0) continue;
            for (int ii = 0; ii < runLength; ++ii) {
                this.values[i + ii] = new long[arrayLength];
            }
        }
        for (i = 0; i < this.values.length; ++i) {
            int length = this.values[i] == null ? 0 : this.values[i].length;
            for (int ii = 0; ii < length; ++ii) {
                this.values[i][ii] = reader.readInt64();
            }
            reporter.reportNextOrThrow();
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        int length;
        int i;
        writer.writeVersion(0);
        writer.writeInt32(this.values.length);
        int currentLenght = -1;
        int count = 0;
        for (i = 0; i < this.values.length; ++i) {
            int n = length = this.values[i] == null ? 0 : this.values[i].length;
            if (length != currentLenght) {
                if (currentLenght != -1) {
                    writer.writeInt8(count);
                    writer.writeInt32(currentLenght);
                }
                currentLenght = length;
                count = 1;
                continue;
            }
            if (++count != 255) continue;
            writer.writeInt8(count);
            writer.writeInt32(currentLenght);
            count = 0;
        }
        if (count > 0) {
            writer.writeInt8(count);
            writer.writeInt32(currentLenght);
        }
        for (i = 0; i < this.values.length; ++i) {
            length = this.values[i] == null ? 0 : this.values[i].length;
            for (int ii = 0; ii < length; ++ii) {
                writer.writeInt64(this.values[i][ii]);
            }
            reporter.reportNextOrThrow();
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }

    public void setList(long[][] valuesList) {
        this.values = valuesList;
    }
}

