/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class MethodFilterColumn
implements SerializableColumn<MethodFilter> {
    private static final int VERSION = 0;
    private MethodFilter[] filters = new MethodFilter[0];

    @Override
    public void fromList(List<MethodFilter> list) {
        this.filters = list.toArray(new MethodFilter[list.size()]);
    }

    @Override
    public MethodFilter get(int index) {
        return this.filters[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.filters = new MethodFilter[reader.readInt32()];
        for (int i = 0; i < this.filters.length; ++i) {
            reporter.reportNextOrThrow();
            this.filters[i] = new MethodFilter(reader);
        }
    }

    @Override
    public int size() {
        return this.filters.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.filters.length);
        for (MethodFilter filter : this.filters) {
            reporter.reportNextOrThrow();
            filter.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

