/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.ClassColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.sync.MonitorObjectColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import com.sap.jvm.profiling.snapshot.util.column.ObjectColumn;
import java.io.IOException;
import java.util.AbstractList;
import java.util.List;

public class MonitorObjectColumnImpl
extends LongColumnBase
implements SerializableColumn<MonitorObject>,
MonitorObjectColumn {
    private static final int VERSION = 1;
    private final LongValueColumnImpl idColumn = new LongValueColumnImpl(this, 0);
    private final ClassColumn classColumn;

    public MonitorObjectColumnImpl(ProfilingSession session) {
        super(1);
        this.classColumn = new ClassColumn(session);
    }

    @Override
    public void fromList(final List<MonitorObject> list) {
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getObjectId();
        }
        this.convertColumnIfPossible(0);
        this.classColumn.fromList((List<ClassObject>)new AbstractList<ClassObject>(){

            @Override
            public ClassObject get(int index) {
                return ((MonitorObject)list.get(index)).getClassObject();
            }

            @Override
            public int size() {
                return list.size();
            }
        });
    }

    @Override
    public MonitorObject get(int index) {
        return new MonitorObject(this.getValue(0, index), this.classColumn.get(index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.classColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.classColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + this.classColumn.getWork(size);
    }

    @Override
    public ObjectColumn<ClassObject> getClassColumn() {
        return this.classColumn;
    }

    @Override
    public LongValueColumn getObjectIdColumn() {
        return this.idColumn;
    }
}

