/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.resource.MptSpecName;
import java.io.IOException;
import java.util.List;

public class MptSpecNameColumn
implements SerializableColumn<MptSpecName> {
    private static final int VERSION = 0;
    private MptSpecName[] names;

    @Override
    public void fromList(List<MptSpecName> list) {
        this.names = list.toArray(new MptSpecName[list.size()]);
    }

    @Override
    public MptSpecName get(int index) {
        return this.names[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.names = new MptSpecName[reader.readInt32()];
        for (int i = 0; i < this.names.length; ++i) {
            reporter.reportNextOrThrow();
            this.names[i] = new MptSpecName(reader);
        }
    }

    @Override
    public int size() {
        return this.names.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.names.length);
        for (MptSpecName t : this.names) {
            reporter.reportNextOrThrow();
            t.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

