/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkIpAddressColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NetworkConnectionColumnImpl
extends LongColumnBase
implements SerializableColumn<NetworkConnection>,
NetworkConnectionColumn {
    private static final int VERSION = 1;
    private static final int LOCAL_PORT_COLUMN = 0;
    private static final int REMOTE_PORT_COLUMN = 1;
    private static final int SOCKET_TYPE_COLUMN = 2;
    private static final int NR_OF_COLUMNS = 3;
    private static final int STREAM_VALUE = 1;
    private static final int DATAGRAM_VALUE = 0;
    private final NetworkIpAddressColumn localAddressColumn = new NetworkIpAddressColumn();
    private final LongValueColumnImpl localPortColumn = new LongValueColumnImpl(this, 0);
    private final NetworkIpAddressColumn remoteAddressColumn = new NetworkIpAddressColumn();
    private final LongValueColumnImpl remotePortColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl socketTypeColumn = new LongValueColumnImpl(this, 2);

    public NetworkConnectionColumnImpl() {
        super(3);
    }

    @Override
    public void fromList(List<NetworkConnection> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getLocalPort();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getRemotePort();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).isStreamSocket() ? 1L : 0L;
        }
        this.convertColumnIfPossible(2);
        ArrayList<IpAddress> localAddresses = new ArrayList<IpAddress>(nrOfRows);
        ArrayList<IpAddress> remoteAddresses = new ArrayList<IpAddress>(nrOfRows);
        for (int i2 = 0; i2 < nrOfRows; ++i2) {
            localAddresses.add(list.get(i2).getLocalAddress());
            remoteAddresses.add(list.get(i2).getRemoteAddress());
        }
        this.localAddressColumn.fromList((List<IpAddress>)localAddresses);
        this.remoteAddressColumn.fromList((List<IpAddress>)remoteAddresses);
    }

    @Override
    public NetworkConnection get(int index) {
        return new NetworkConnection(this.localAddressColumn.get(index), (char)this.getValue(0, index), this.remoteAddressColumn.get(index), (char)this.getValue(1, index), this.getValue(2, index) == 1L);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.localAddressColumn.read(reader, reporter);
        this.remoteAddressColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.localAddressColumn.write(writer, reporter);
        this.remoteAddressColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + 2L * this.localAddressColumn.getWork(size);
    }

    public NetworkIpAddressColumn getLocalAddressColumn() {
        return this.localAddressColumn;
    }

    @Override
    public LongValueColumn getLocalPortColumn() {
        return this.localPortColumn;
    }

    public NetworkIpAddressColumn getRemoteAddressColumn() {
        return this.remoteAddressColumn;
    }

    @Override
    public LongValueColumn getRemotePortColumn() {
        return this.remotePortColumn;
    }

    @Override
    public LongValueColumn getSocketTypeColumn() {
        return this.socketTypeColumn;
    }
}

