/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkIpAddressColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.StringColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkHostColumn;
import com.sap.jvm.profiling.snapshot.util.column.ObjectColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NetworkHostColumnImpl
implements SerializableColumn<NetworkHost>,
NetworkHostColumn {
    private static final int VERSION = 1;
    private final StringColumn hostnameColumn = new StringColumn();
    private final NetworkIpAddressColumn addressColumn = new NetworkIpAddressColumn();

    @Override
    public void fromList(List<NetworkHost> list) {
        int nrOfRows = list.size();
        ArrayList<String> hostnames = new ArrayList<String>(nrOfRows);
        ArrayList<IpAddress> addresses = new ArrayList<IpAddress>(nrOfRows);
        for (int i = 0; i < nrOfRows; ++i) {
            hostnames.add(list.get(i).getHostname());
            addresses.add(list.get(i).getAddress());
        }
        this.hostnameColumn.fromList((List<String>)hostnames);
        this.addressColumn.fromList((List<IpAddress>)addresses);
    }

    @Override
    public NetworkHost get(int index) {
        return new NetworkHost(this.hostnameColumn.get(index), this.addressColumn.get(index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.hostnameColumn.read(reader, reporter);
        this.addressColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.hostnameColumn.write(writer, reporter);
        this.addressColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return this.hostnameColumn.getWork(size) + this.addressColumn.getWork(size);
    }

    public StringColumn getHostnameColumn() {
        return this.hostnameColumn;
    }

    @Override
    public ObjectColumn<IpAddress> getAddressColumn() {
        return this.addressColumn;
    }

    @Override
    public int size() {
        assert (this.hostnameColumn.size() == this.addressColumn.size());
        return this.hostnameColumn.size();
    }
}

