/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class NetworkIpAddressColumn
implements SerializableColumn<IpAddress> {
    private static final int VERSION = 0;
    private IpAddress[] addresses = new IpAddress[0];

    @Override
    public void fromList(List<IpAddress> list) {
        this.addresses = list.toArray(new IpAddress[list.size()]);
    }

    @Override
    public IpAddress get(int index) {
        return this.addresses[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.addresses = new IpAddress[reader.readInt32()];
        for (int i = 0; i < this.addresses.length; ++i) {
            reporter.reportNextOrThrow();
            this.addresses[i] = IpAddressUtil.read((ResourceReader)reader);
        }
    }

    @Override
    public int size() {
        return this.addresses.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.addresses.length);
        for (IpAddress addr : this.addresses) {
            reporter.reportNextOrThrow();
            IpAddressUtil.write((ResourceWriter)writer, (IpAddress)addr);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

