/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkLatenciesColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class NetworkLatenciesColumnImpl
extends LongColumnBase
implements SerializableColumn<NetworkLatencies>,
NetworkLatenciesColumn {
    private static final long INVALID = 0L;
    private static final int VERSION = 1;
    private static final int MIN_READ_WRITE_LATENCY_COLUMN = 0;
    private static final int MAX_READ_WRITE_LATENCY_COLUMN = 1;
    private static final int READ_WRITE_LATENCY_SUM_COLUMN = 2;
    private static final int READ_WRITE_LATENCY_COUNT_COLUMN = 3;
    private static final int MIN_WRITE_READ_LATENCY_COLUMN = 4;
    private static final int MAX_WRITE_READ_LATENCY_COLUMN = 5;
    private static final int WRITE_READ_LATENCY_SUM_COLUMN = 6;
    private static final int WRITE_READ_LATENCY_COUNT_COLUMN = 7;
    private static final int MIN_DEFAULT_LATENCY_COLUMN = 8;
    private static final int MAX_DEFAULT_LATENCY_COLUMN = 9;
    private static final int DEFAULT_LATENCY_SUM_COLUMN = 10;
    private static final int DEFAULT_LATENCY_COUNT_COLUMN = 11;
    private static final int NR_OF_COLUMNS = 12;
    private final LongValueColumnImpl minReadWriteLatencyColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl maxReadWriteLatencyColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl readWriteLatencySumColumn = new LongValueColumnImpl(this, 2);
    private final LongValueColumnImpl readWriteLatencyCountColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl minWriteReadLatencyColumn = new LongValueColumnImpl(this, 4);
    private final LongValueColumnImpl maxWriteReadLatencyColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl writeReadLatencySumColumn = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl writeReadLatencyCountColumn = new LongValueColumnImpl(this, 7);
    private final LongValueColumnImpl minDefaultLatencyColumn = new LongValueColumnImpl(this, 8);
    private final LongValueColumnImpl maxDefaultLatencyColumn = new LongValueColumnImpl(this, 9);
    private final LongValueColumnImpl defaultLatencySumColumn = new LongValueColumnImpl(this, 10);
    private final LongValueColumnImpl defaultLatencyCountColumn = new LongValueColumnImpl(this, 11);

    public NetworkLatenciesColumnImpl() {
        super(12);
    }

    @Override
    public void fromList(List<NetworkLatencies> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getMinReadWriteLatency();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getMaxReadWriteLatency();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getReadWriteLatencySum();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[3][i] = list.get(i).getReadWriteLatencyCount();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[4][i] = list.get(i).getMinWriteReadLatency();
        }
        this.convertColumnIfPossible(4);
        values[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[5][i] = list.get(i).getMaxWriteReadLatency();
        }
        this.convertColumnIfPossible(5);
        values[6] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[6][i] = list.get(i).getWriteReadLatencySum();
        }
        this.convertColumnIfPossible(6);
        values[7] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[7][i] = list.get(i).getWriteReadLatencyCount();
        }
        this.convertColumnIfPossible(7);
        values[8] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[8][i] = list.get(i).getMinDefaultLatency();
        }
        this.convertColumnIfPossible(8);
        values[9] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[9][i] = list.get(i).getMaxDefaultLatency();
        }
        this.convertColumnIfPossible(9);
        values[10] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[10][i] = list.get(i).getDefaultLatencySum();
        }
        this.convertColumnIfPossible(10);
        values[11] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[11][i] = list.get(i).getDefaultLatencyCount();
        }
        this.convertColumnIfPossible(11);
    }

    @Override
    public NetworkLatencies get(int index) {
        return new NetworkLatencies(this.getValue(0, index), this.getValue(1, index), this.getValue(2, index), this.getValue(3, index), this.getValue(4, index), this.getValue(5, index), this.getValue(6, index), this.getValue(7, index), this.getValue(8, index), this.getValue(9, index), this.getValue(10, index), this.getValue(11, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getMinReadWriteLatencyColumn() {
        return this.minReadWriteLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxReadWriteLatencyColumn() {
        return this.maxReadWriteLatencyColumn;
    }

    @Override
    public LongValueColumn getReadWriteLatencySumColumn() {
        return this.readWriteLatencySumColumn;
    }

    @Override
    public LongValueColumn getReadWriteLatencyCountColumn() {
        return this.readWriteLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageReadWriteLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(3, i);
            values[0][i] = div == 0L ? 0L : this.getValue(2, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinWriteReadLatencyColumn() {
        return this.minWriteReadLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxWriteReadLatencyColumn() {
        return this.maxWriteReadLatencyColumn;
    }

    @Override
    public LongValueColumn getWriteReadLatencySumColumn() {
        return this.writeReadLatencySumColumn;
    }

    @Override
    public LongValueColumn getWriteReadLatencyCountColumn() {
        return this.writeReadLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageWriteReadLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(7, i);
            values[0][i] = div == 0L ? 0L : this.getValue(6, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinDefaultLatencyColumn() {
        return this.minDefaultLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxDefaultLatencyColumn() {
        return this.maxDefaultLatencyColumn;
    }

    @Override
    public LongValueColumn getDefaultLatencySumColumn() {
        return this.defaultLatencySumColumn;
    }

    @Override
    public LongValueColumn getDefaultLatencyCountColumn() {
        return this.defaultLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageDefaultLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(11, i);
            values[0][i] = div == 0L ? 0L : this.getValue(10, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }
}

