/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.resource.NetworkLatencyId;
import java.io.IOException;
import java.util.List;

public class NetworkLatencyIdColumn
implements SerializableColumn<NetworkLatencyId> {
    private static final int VERSION = 0;
    private NetworkLatencyId[] networkLatencyIds = new NetworkLatencyId[0];

    @Override
    public void fromList(List<NetworkLatencyId> list) {
        this.networkLatencyIds = list.toArray(new NetworkLatencyId[list.size()]);
    }

    @Override
    public NetworkLatencyId get(int index) {
        return this.networkLatencyIds[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.networkLatencyIds = new NetworkLatencyId[reader.readInt32()];
        for (int i = 0; i < this.networkLatencyIds.length; ++i) {
            reporter.reportNextOrThrow();
            this.networkLatencyIds[i] = new NetworkLatencyId(reader);
        }
    }

    @Override
    public int size() {
        return this.networkLatencyIds.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.networkLatencyIds.length);
        for (NetworkLatencyId latencyId : this.networkLatencyIds) {
            reporter.reportNextOrThrow();
            latencyId.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

