/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetailsColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class NetworkOperationsAndDetailsColumnImpl
extends LongColumnBase
implements SerializableColumn<NetworkOperationsAndDetails>,
NetworkOperationsAndDetailsColumn {
    private static final long INVALID = 0L;
    private static final int VERSION = 1;
    private static final int FD_COLUMN = 0;
    private static final int OPEN_TIMESTAMP_COLUMN = 1;
    private static final int OPENING_THREAD_ID_COLUMN = 2;
    private static final int CLOSE_TIMESTAMP_COLUMN = 3;
    private static final int CLOSING_THREAD_ID_COLUMN = 4;
    private static final int READ_OPERATIONS_COLUMN = 5;
    private static final int WRITE_OPERATIONS_COLUMN = 6;
    private static final int READ_TIME_COLUMN = 7;
    private static final int WRITE_TIME_COLUMN = 8;
    private static final int READ_BYTES_COLUMN = 9;
    private static final int WRITTEN_BYTES_COLUMN = 10;
    private static final int MIN_READ_WRITE_LATENCY_COLUMN = 11;
    private static final int MAX_READ_WRITE_LATENCY_COLUMN = 12;
    private static final int READ_WRITE_LATENCY_SUM_COLUMN = 13;
    private static final int READ_WRITE_LATENCY_COUNT_COLUMN = 14;
    private static final int MIN_WRITE_READ_LATENCY_COLUMN = 15;
    private static final int MAX_WRITE_READ_LATENCY_COLUMN = 16;
    private static final int WRITE_READ_LATENCY_SUM_COLUMN = 17;
    private static final int WRITE_READ_LATENCY_COUNT_COLUMN = 18;
    private static final int MIN_DEFAULT_LATENCY_COLUMN = 19;
    private static final int MAX_DEFAULT_LATENCY_COLUMN = 20;
    private static final int DEFAULT_LATENCY_SUM_COLUMN = 21;
    private static final int DEFAULT_LATENCY_COUNT_COLUMN = 22;
    private static final int NR_OF_COLUMNS = 23;
    private final LongValueColumnImpl fdColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl openTimestampColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl closeTimestampColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl openingThreadIdColumn = new LongValueColumnImpl(this, 2);
    private final UTF8StringColumn openingThreadNameColumn;
    private final LongValueColumnImpl closingThreadIdColumn = new LongValueColumnImpl(this, 4);
    private final UTF8StringColumn closingThreadNameColumn;
    private final LongValueColumnImpl readOperationsColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl writeOperationsColumn = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl readTimeColumn = new LongValueColumnImpl(this, 7);
    private final LongValueColumnImpl writeTimeColumn = new LongValueColumnImpl(this, 8);
    private final LongValueColumnImpl readBytesColumn = new LongValueColumnImpl(this, 9);
    private final LongValueColumnImpl writtenBytesColumn = new LongValueColumnImpl(this, 10);
    private final LongValueColumnImpl minReadWriteLatencyColumn;
    private final LongValueColumnImpl maxReadWriteLatencyColumn;
    private final LongValueColumnImpl readWriteLatencySumColumn;
    private final LongValueColumnImpl readWriteLatencyCountColumn;
    private final LongValueColumnImpl minWriteReadLatencyColumn;
    private final LongValueColumnImpl maxWriteReadLatencyColumn;
    private final LongValueColumnImpl writeReadLatencySumColumn;
    private final LongValueColumnImpl writeReadLatencyCountColumn;
    private final LongValueColumnImpl minDefaultLatencyColumn;
    private final LongValueColumnImpl maxDefaultLatencyColumn;
    private final LongValueColumnImpl defaultLatencySumColumn;
    private final LongValueColumnImpl defaultLatencyCountColumn;

    public NetworkOperationsAndDetailsColumnImpl() {
        super(23);
        this.openingThreadNameColumn = new UTF8StringColumn();
        this.closingThreadNameColumn = new UTF8StringColumn();
        this.minReadWriteLatencyColumn = new LongValueColumnImpl(this, 11);
        this.maxReadWriteLatencyColumn = new LongValueColumnImpl(this, 12);
        this.readWriteLatencySumColumn = new LongValueColumnImpl(this, 13);
        this.readWriteLatencyCountColumn = new LongValueColumnImpl(this, 14);
        this.minWriteReadLatencyColumn = new LongValueColumnImpl(this, 15);
        this.maxWriteReadLatencyColumn = new LongValueColumnImpl(this, 16);
        this.writeReadLatencySumColumn = new LongValueColumnImpl(this, 17);
        this.writeReadLatencyCountColumn = new LongValueColumnImpl(this, 18);
        this.minDefaultLatencyColumn = new LongValueColumnImpl(this, 19);
        this.maxDefaultLatencyColumn = new LongValueColumnImpl(this, 20);
        this.defaultLatencySumColumn = new LongValueColumnImpl(this, 21);
        this.defaultLatencyCountColumn = new LongValueColumnImpl(this, 22);
    }

    @Override
    public void fromList(List<NetworkOperationsAndDetails> list) {
        int i;
        int i2;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[0][i2] = list.get(i2).getFd();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[1][i2] = list.get(i2).getOpenTimestamp();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[2][i2] = list.get(i2).getOpeningThreadId();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[3][i2] = list.get(i2).getCloseTimestamp();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[4][i2] = list.get(i2).getClosingThreadId();
        }
        this.convertColumnIfPossible(4);
        values[5] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[5][i2] = list.get(i2).getReadOperations();
        }
        this.convertColumnIfPossible(5);
        values[6] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[6][i2] = list.get(i2).getWriteOperations();
        }
        this.convertColumnIfPossible(6);
        values[7] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[7][i2] = list.get(i2).getReadTime();
        }
        this.convertColumnIfPossible(7);
        values[8] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[8][i2] = list.get(i2).getWriteTime();
        }
        this.convertColumnIfPossible(8);
        values[9] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[9][i2] = list.get(i2).getReadBytes();
        }
        this.convertColumnIfPossible(9);
        values[10] = new long[nrOfRows];
        for (i2 = 0; i2 < nrOfRows; ++i2) {
            values[10][i2] = list.get(i2).getWrittenBytes();
        }
        this.convertColumnIfPossible(10);
        UTF8String[] openingNames = new UTF8String[nrOfRows];
        UTF8String[] closingNames = new UTF8String[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            openingNames[i] = list.get(i).getOpeningThreadName();
            closingNames[i] = list.get(i).getClosingThreadName();
        }
        this.openingThreadNameColumn.setList(openingNames);
        this.closingThreadNameColumn.setList(closingNames);
        values[11] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[11][i] = list.get(i).getMinReadWriteLatency();
        }
        this.convertColumnIfPossible(11);
        values[12] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[12][i] = list.get(i).getMaxReadWriteLatency();
        }
        this.convertColumnIfPossible(12);
        values[13] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[13][i] = list.get(i).getReadWriteLatencySum();
        }
        this.convertColumnIfPossible(13);
        values[14] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[14][i] = list.get(i).getReadWriteLatencyCount();
        }
        this.convertColumnIfPossible(14);
        values[15] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[15][i] = list.get(i).getMinWriteReadLatency();
        }
        this.convertColumnIfPossible(15);
        values[16] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[16][i] = list.get(i).getMaxWriteReadLatency();
        }
        this.convertColumnIfPossible(16);
        values[17] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[17][i] = list.get(i).getWriteReadLatencySum();
        }
        this.convertColumnIfPossible(17);
        values[18] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[18][i] = list.get(i).getWriteReadLatencyCount();
        }
        this.convertColumnIfPossible(18);
        values[19] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[19][i] = list.get(i).getMinDefaultLatency();
        }
        this.convertColumnIfPossible(19);
        values[20] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[20][i] = list.get(i).getMaxDefaultLatency();
        }
        this.convertColumnIfPossible(20);
        values[21] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[21][i] = list.get(i).getDefaultLatencySum();
        }
        this.convertColumnIfPossible(21);
        values[22] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[22][i] = list.get(i).getDefaultLatencyCount();
        }
        this.convertColumnIfPossible(22);
    }

    @Override
    public NetworkOperationsAndDetails get(int index) {
        return new NetworkOperationsAndDetails(this.getValue(0, index), this.getValue(1, index), this.getValue(2, index), this.openingThreadNameColumn.get(index), this.getValue(3, index), this.getValue(4, index), this.closingThreadNameColumn.get(index), this.getValue(9, index), this.getValue(10, index), this.getValue(7, index), this.getValue(8, index), this.getValue(5, index), this.getValue(6, index), this.getValue(11, index), this.getValue(12, index), this.getValue(13, index), this.getValue(14, index), this.getValue(15, index), this.getValue(16, index), this.getValue(17, index), this.getValue(18, index), this.getValue(19, index), this.getValue(20, index), this.getValue(21, index), this.getValue(22, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.openingThreadNameColumn.read(reader, reporter);
        this.closingThreadNameColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.openingThreadNameColumn.write(writer, reporter);
        this.closingThreadNameColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + 2L * this.openingThreadNameColumn.getWork(size);
    }

    @Override
    public LongValueColumn getCloseTimestampColumn() {
        return this.closeTimestampColumn;
    }

    @Override
    public LongValueColumn getClosingThreadIdColumn() {
        return this.closingThreadIdColumn;
    }

    @Override
    public UTF8StringColumn getClosingThreadNameColumn() {
        return this.closingThreadNameColumn;
    }

    @Override
    public LongValueColumn getFdColumn() {
        return this.fdColumn;
    }

    @Override
    public LongValueColumn getOpenTimestampColumn() {
        return this.openTimestampColumn;
    }

    @Override
    public LongValueColumn getOpeningThreadIdColumn() {
        return this.openingThreadIdColumn;
    }

    @Override
    public UTF8StringColumn getOpeningThreadNameColumn() {
        return this.openingThreadNameColumn;
    }

    @Override
    public LongValueColumn getReadBytesColumn() {
        return this.readBytesColumn;
    }

    @Override
    public LongValueColumn getReadOperationsColumn() {
        return this.readOperationsColumn;
    }

    @Override
    public LongValueColumn getReadTimeColumn() {
        return this.readTimeColumn;
    }

    @Override
    public LongValueColumn getWriteOperationsColumn() {
        return this.writeOperationsColumn;
    }

    @Override
    public LongValueColumn getWriteTimeColumn() {
        return this.writeTimeColumn;
    }

    @Override
    public LongValueColumn getWrittenBytesColumn() {
        return this.writtenBytesColumn;
    }

    @Override
    public LongValueColumn getReadBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(5, i);
            values[0][i] = div == 0L ? 0L : this.getValue(7, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getReadTroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(7, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(9, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerReadOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(6, i);
            values[0][i] = div == 0L ? 0L : this.getValue(9, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerWriteOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(6, i);
            values[0][i] = div == 0L ? 0L : this.getValue(8, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWriteThroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(8, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(10, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWrittenBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(6, i);
            values[0][i] = div == 0L ? 0L : this.getValue(10, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinReadWriteLatencyColumn() {
        return this.minReadWriteLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxReadWriteLatencyColumn() {
        return this.maxReadWriteLatencyColumn;
    }

    @Override
    public LongValueColumn getReadWriteLatencySumColumn() {
        return this.readWriteLatencySumColumn;
    }

    @Override
    public LongValueColumn getReadWriteLatencyCountColumn() {
        return this.readWriteLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageReadWriteLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(14, i);
            values[0][i] = div == 0L ? 0L : this.getValue(13, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinWriteReadLatencyColumn() {
        return this.minWriteReadLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxWriteReadLatencyColumn() {
        return this.maxWriteReadLatencyColumn;
    }

    @Override
    public LongValueColumn getWriteReadLatencySumColumn() {
        return this.writeReadLatencySumColumn;
    }

    @Override
    public LongValueColumn getWriteReadLatencyCountColumn() {
        return this.writeReadLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageWriteReadLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(18, i);
            values[0][i] = div == 0L ? 0L : this.getValue(17, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinDefaultLatencyColumn() {
        return this.minDefaultLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxDefaultLatencyColumn() {
        return this.maxDefaultLatencyColumn;
    }

    @Override
    public LongValueColumn getDefaultLatencySumColumn() {
        return this.defaultLatencySumColumn;
    }

    @Override
    public LongValueColumn getDefaultLatencyCountColumn() {
        return this.defaultLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageDefaultLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(22, i);
            values[0][i] = div == 0L ? 0L : this.getValue(21, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }
}

