/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatenciesColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class NetworkOperationsAndLatenciesColumnImpl
extends LongColumnBase
implements SerializableColumn<NetworkOperationsAndLatencies>,
NetworkOperationsAndLatenciesColumn {
    private static final long INVALID = 0L;
    private static final int VERSION = 1;
    private static final int OPEN_COUNTS_COLUMN = 0;
    private static final int CLOSE_COUNTS_COLUMN = 1;
    private static final int READ_OPERATIONS_COLUMN = 2;
    private static final int WRITE_OPERATIONS_COLUMN = 3;
    private static final int READ_TIME_COLUMN = 4;
    private static final int WRITE_TIME_COLUMN = 5;
    private static final int READ_BYTES_COLUMN = 6;
    private static final int WRITTEN_BYTES_COLUMN = 7;
    private static final int MIN_READ_WRITE_LATENCY_COLUMN = 8;
    private static final int MAX_READ_WRITE_LATENCY_COLUMN = 9;
    private static final int READ_WRITE_LATENCY_SUM_COLUMN = 10;
    private static final int READ_WRITE_LATENCY_COUNT_COLUMN = 11;
    private static final int MIN_WRITE_READ_LATENCY_COLUMN = 12;
    private static final int MAX_WRITE_READ_LATENCY_COLUMN = 13;
    private static final int WRITE_READ_LATENCY_SUM_COLUMN = 14;
    private static final int WRITE_READ_LATENCY_COUNT_COLUMN = 15;
    private static final int MIN_DEFAULT_LATENCY_COLUMN = 16;
    private static final int MAX_DEFAULT_LATENCY_COLUMN = 17;
    private static final int DEFAULT_LATENCY_SUM_COLUMN = 18;
    private static final int DEFAULT_LATENCY_COUNT_COLUMN = 19;
    private static final int NR_OF_COLUMNS = 20;
    private final LongValueColumnImpl openCountsColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl closeCountsColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl readOperationsColumn = new LongValueColumnImpl(this, 2);
    private final LongValueColumnImpl writeOperationsColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl readTimeColumn = new LongValueColumnImpl(this, 4);
    private final LongValueColumnImpl writeTimeColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl readBytesColumn = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl writtenBytesColumn = new LongValueColumnImpl(this, 7);
    private final LongValueColumnImpl minReadWriteLatencyColumn = new LongValueColumnImpl(this, 8);
    private final LongValueColumnImpl maxReadWriteLatencyColumn = new LongValueColumnImpl(this, 9);
    private final LongValueColumnImpl readWriteLatencySumColumn = new LongValueColumnImpl(this, 10);
    private final LongValueColumnImpl readWriteLatencyCountColumn = new LongValueColumnImpl(this, 11);
    private final LongValueColumnImpl minWriteReadLatencyColumn = new LongValueColumnImpl(this, 12);
    private final LongValueColumnImpl maxWriteReadLatencyColumn = new LongValueColumnImpl(this, 13);
    private final LongValueColumnImpl writeReadLatencySumColumn = new LongValueColumnImpl(this, 14);
    private final LongValueColumnImpl writeReadLatencyCountColumn = new LongValueColumnImpl(this, 15);
    private final LongValueColumnImpl minDefaultLatencyColumn = new LongValueColumnImpl(this, 16);
    private final LongValueColumnImpl maxDefaultLatencyColumn = new LongValueColumnImpl(this, 17);
    private final LongValueColumnImpl defaultLatencySumColumn = new LongValueColumnImpl(this, 18);
    private final LongValueColumnImpl defaultLatencyCountColumn = new LongValueColumnImpl(this, 19);

    public NetworkOperationsAndLatenciesColumnImpl() {
        super(20);
    }

    @Override
    public void fromList(List<NetworkOperationsAndLatencies> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getOpenCount();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getCloseCount();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getReadOperations();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[3][i] = list.get(i).getWriteOperations();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[4][i] = list.get(i).getReadTime();
        }
        this.convertColumnIfPossible(4);
        values[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[5][i] = list.get(i).getWriteTime();
        }
        this.convertColumnIfPossible(5);
        values[6] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[6][i] = list.get(i).getReadBytes();
        }
        this.convertColumnIfPossible(6);
        values[7] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[7][i] = list.get(i).getWrittenBytes();
        }
        this.convertColumnIfPossible(7);
        values[8] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[8][i] = list.get(i).getMinReadWriteLatency();
        }
        this.convertColumnIfPossible(8);
        values[9] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[9][i] = list.get(i).getMaxReadWriteLatency();
        }
        this.convertColumnIfPossible(9);
        values[10] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[10][i] = list.get(i).getReadWriteLatencySum();
        }
        this.convertColumnIfPossible(10);
        values[11] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[11][i] = list.get(i).getReadWriteLatencyCount();
        }
        this.convertColumnIfPossible(11);
        values[12] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[12][i] = list.get(i).getMinWriteReadLatency();
        }
        this.convertColumnIfPossible(12);
        values[13] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[13][i] = list.get(i).getMaxWriteReadLatency();
        }
        this.convertColumnIfPossible(13);
        values[14] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[14][i] = list.get(i).getWriteReadLatencySum();
        }
        this.convertColumnIfPossible(14);
        values[15] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[15][i] = list.get(i).getWriteReadLatencyCount();
        }
        this.convertColumnIfPossible(15);
        values[16] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[16][i] = list.get(i).getMinDefaultLatency();
        }
        this.convertColumnIfPossible(16);
        values[17] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[17][i] = list.get(i).getMaxDefaultLatency();
        }
        this.convertColumnIfPossible(17);
        values[18] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[18][i] = list.get(i).getDefaultLatencySum();
        }
        this.convertColumnIfPossible(18);
        values[19] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[19][i] = list.get(i).getDefaultLatencyCount();
        }
        this.convertColumnIfPossible(19);
    }

    @Override
    public NetworkOperationsAndLatencies get(int index) {
        return new NetworkOperationsAndLatencies(this.getValue(0, index), this.getValue(1, index), this.getValue(6, index), this.getValue(7, index), this.getValue(4, index), this.getValue(5, index), this.getValue(2, index), this.getValue(3, index), this.getValue(8, index), this.getValue(9, index), this.getValue(10, index), this.getValue(11, index), this.getValue(12, index), this.getValue(13, index), this.getValue(14, index), this.getValue(15, index), this.getValue(16, index), this.getValue(17, index), this.getValue(18, index), this.getValue(19, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getCloseCountColumn() {
        return this.closeCountsColumn;
    }

    @Override
    public LongValueColumn getOpenCountColumn() {
        return this.openCountsColumn;
    }

    @Override
    public LongValueColumn getReadBytesColumn() {
        return this.readBytesColumn;
    }

    @Override
    public LongValueColumn getReadOperationsColumn() {
        return this.readOperationsColumn;
    }

    @Override
    public LongValueColumn getReadTimeColumn() {
        return this.readTimeColumn;
    }

    @Override
    public LongValueColumn getWriteOperationsColumn() {
        return this.writeOperationsColumn;
    }

    @Override
    public LongValueColumn getWriteTimeColumn() {
        return this.writeTimeColumn;
    }

    @Override
    public LongValueColumn getWrittenBytesColumn() {
        return this.writtenBytesColumn;
    }

    @Override
    public LongValueColumn getReadBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(2, i);
            values[0][i] = div == 0L ? 0L : this.getValue(6, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getReadTroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(4, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(6, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerReadOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(2, i);
            values[0][i] = div == 0L ? 0L : this.getValue(4, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerWriteOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(3, i);
            values[0][i] = div == 0L ? 0L : this.getValue(5, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWriteThroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(5, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(7, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWrittenBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(3, i);
            values[0][i] = div == 0L ? 0L : this.getValue(7, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinReadWriteLatencyColumn() {
        return this.minReadWriteLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxReadWriteLatencyColumn() {
        return this.maxReadWriteLatencyColumn;
    }

    @Override
    public LongValueColumn getReadWriteLatencySumColumn() {
        return this.readWriteLatencySumColumn;
    }

    @Override
    public LongValueColumn getReadWriteLatencyCountColumn() {
        return this.readWriteLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageReadWriteLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(11, i);
            values[0][i] = div == 0L ? 0L : this.getValue(10, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinWriteReadLatencyColumn() {
        return this.minWriteReadLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxWriteReadLatencyColumn() {
        return this.maxWriteReadLatencyColumn;
    }

    @Override
    public LongValueColumn getWriteReadLatencySumColumn() {
        return this.writeReadLatencySumColumn;
    }

    @Override
    public LongValueColumn getWriteReadLatencyCountColumn() {
        return this.writeReadLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageWriteReadLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(15, i);
            values[0][i] = div == 0L ? 0L : this.getValue(14, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getMinDefaultLatencyColumn() {
        return this.minDefaultLatencyColumn;
    }

    @Override
    public LongValueColumn getMaxDefaultLatencyColumn() {
        return this.maxDefaultLatencyColumn;
    }

    @Override
    public LongValueColumn getDefaultLatencySumColumn() {
        return this.defaultLatencySumColumn;
    }

    @Override
    public LongValueColumn getDefaultLatencyCountColumn() {
        return this.defaultLatencyCountColumn;
    }

    @Override
    public LongValueColumn getAverageDefaultLatencyColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(19, i);
            values[0][i] = div == 0L ? 0L : this.getValue(18, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }
}

