/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class NetworkOperationsColumnImpl
extends LongColumnBase
implements SerializableColumn<NetworkOperations>,
NetworkOperationsColumn {
    private static final long INVALID = 0L;
    private static final int VERSION = 1;
    private static final int OPEN_COUNTS_COLUMN = 0;
    private static final int CLOSE_COUNTS_COLUMN = 1;
    private static final int READ_OPERATIONS_COLUMN = 2;
    private static final int WRITE_OPERATIONS_COLUMN = 3;
    private static final int READ_TIME_COLUMN = 4;
    private static final int WRITE_TIME_COLUMN = 5;
    private static final int READ_BYTES_COLUMN = 6;
    private static final int WRITTEN_BYTES_COLUMN = 7;
    private static final int NR_OF_COLUMNS = 8;
    private final LongValueColumnImpl openCountsColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl closeCountsColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl readOperationsColumn = new LongValueColumnImpl(this, 2);
    private final LongValueColumnImpl writeOperationsColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl readTimeColumn = new LongValueColumnImpl(this, 4);
    private final LongValueColumnImpl writeTimeColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl readBytesColumn = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl writtenBytesColumn = new LongValueColumnImpl(this, 7);

    public NetworkOperationsColumnImpl() {
        super(8);
    }

    @Override
    public void fromList(List<NetworkOperations> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getOpenCount();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getCloseCount();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getReadOperations();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[3][i] = list.get(i).getWriteOperations();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[4][i] = list.get(i).getReadTime();
        }
        this.convertColumnIfPossible(4);
        values[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[5][i] = list.get(i).getWriteTime();
        }
        this.convertColumnIfPossible(5);
        values[6] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[6][i] = list.get(i).getReadBytes();
        }
        this.convertColumnIfPossible(6);
        values[7] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[7][i] = list.get(i).getWrittenBytes();
        }
        this.convertColumnIfPossible(7);
    }

    @Override
    public NetworkOperations get(int index) {
        return new NetworkOperations(this.getValue(0, index), this.getValue(1, index), this.getValue(6, index), this.getValue(7, index), this.getValue(4, index), this.getValue(5, index), this.getValue(2, index), this.getValue(3, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getCloseCountColumn() {
        return this.closeCountsColumn;
    }

    @Override
    public LongValueColumn getOpenCountColumn() {
        return this.openCountsColumn;
    }

    @Override
    public LongValueColumn getReadBytesColumn() {
        return this.readBytesColumn;
    }

    @Override
    public LongValueColumn getReadOperationsColumn() {
        return this.readOperationsColumn;
    }

    @Override
    public LongValueColumn getReadTimeColumn() {
        return this.readTimeColumn;
    }

    @Override
    public LongValueColumn getWriteOperationsColumn() {
        return this.writeOperationsColumn;
    }

    @Override
    public LongValueColumn getWriteTimeColumn() {
        return this.writeTimeColumn;
    }

    @Override
    public LongValueColumn getWrittenBytesColumn() {
        return this.writtenBytesColumn;
    }

    @Override
    public LongValueColumn getReadBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(2, i);
            values[0][i] = div == 0L ? 0L : this.getValue(6, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getReadTroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(4, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(6, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerReadOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(2, i);
            values[0][i] = div == 0L ? 0L : this.getValue(4, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getTimePerWriteOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(3, i);
            values[0][i] = div == 0L ? 0L : this.getValue(5, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWriteThroughputColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(5, i);
            values[0][i] = div == 0L ? 0L : (long)((double)this.getValue(7, i) * 1.0E9 / (double)div);
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }

    @Override
    public LongValueColumn getWrittenBytesPerOperationColumn() {
        LongColumnBase base = new LongColumnBase(1);
        int nrOfRows = this.size();
        long[][] values = base.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            long div = this.getValue(3, i);
            values[0][i] = div == 0L ? 0L : this.getValue(7, i) / div;
        }
        base.convertColumnIfPossible(0);
        return new LongValueColumnImpl(base, 0);
    }
}

