/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.StringColumn;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import com.sap.jvm.profiling.snapshot.net.NetworkServiceColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NetworkServiceColumnImpl
extends LongColumnBase
implements SerializableColumn<NetworkService>,
NetworkServiceColumn {
    private static final int VERSION = 1;
    private static final int PORT_COLUMN = 0;
    private static final int SERVER_CLIENT_COLUMN = 1;
    private static final int SOCKET_TYPE_COLUMN = 2;
    private static final int NR_OF_COLUMNS = 3;
    private static final int STREAM_VALUE = 1;
    private static final int DATAGRAM_VALUE = 0;
    private final StringColumn serviceNameColumn = new StringColumn();
    private final LongValueColumnImpl portColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl serverClientColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl socketTypeColumn = new LongValueColumnImpl(this, 2);

    public NetworkServiceColumnImpl() {
        super(3);
    }

    @Override
    public void fromList(List<NetworkService> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getPort();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getSideType().getValue();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).isStream() ? 1L : 0L;
        }
        this.convertColumnIfPossible(2);
        ArrayList<String> serviceNames = new ArrayList<String>(nrOfRows);
        for (int i2 = 0; i2 < nrOfRows; ++i2) {
            serviceNames.add(list.get(i2).getServiceName());
        }
        this.serviceNameColumn.fromList((List<String>)serviceNames);
    }

    @Override
    public NetworkService get(int index) {
        return new NetworkService(this.serviceNameColumn.get(index), (char)this.getValue(0, index), NetworkConnectionSideType.get((int)this.getValue(1, index)), this.getValue(2, index) == 1L);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.serviceNameColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.serviceNameColumn.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + this.serviceNameColumn.getWork(size);
    }

    public StringColumn getServiceNameColumn() {
        return this.serviceNameColumn;
    }

    @Override
    public LongValueColumn getPortColumn() {
        return this.portColumn;
    }

    @Override
    public LongValueColumn getServerClientColumn() {
        return this.serverClientColumn;
    }

    @Override
    public LongValueColumn getSocketTypeColumn() {
        return this.socketTypeColumn;
    }
}

