/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class PackageNameColumn
implements SerializableColumn<PackageName> {
    private static final int VERSION = 0;
    private PackageName[] packages = new PackageName[0];

    @Override
    public void fromList(List<PackageName> list) {
        this.packages = list.toArray(new PackageName[list.size()]);
    }

    @Override
    public PackageName get(int index) {
        return this.packages[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.packages = new PackageName[reader.readInt32()];
        for (int i = 0; i < this.packages.length; ++i) {
            reporter.reportNextOrThrow();
            this.packages[i] = reader.readPackageName();
        }
    }

    @Override
    public int size() {
        return this.packages.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.packages.length);
        for (PackageName pkg : this.packages) {
            reporter.reportNextOrThrow();
            writer.writePackageName(pkg);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

