/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.method.parameters.BooleanParameter;
import com.sap.jvm.profiling.method.parameters.ByteParameter;
import com.sap.jvm.profiling.method.parameters.CharParameter;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.DoubleParameter;
import com.sap.jvm.profiling.method.parameters.FloatParameter;
import com.sap.jvm.profiling.method.parameters.IntParameter;
import com.sap.jvm.profiling.method.parameters.LongParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.method.parameters.ShortParameter;
import com.sap.jvm.profiling.method.parameters.StringParameter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.ClassColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.MethodColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParameterColumn
implements SerializableColumn<Parameter> {
    private static final int VERSION = 1;
    private ParameterType type;
    private Parameter[] parameters;
    private LongColumnBase longColumn;
    private float[] floatColumn;
    private double[] doubleColumn;
    private UTF8StringColumn stringColumn;
    private ClassColumn classColumn;
    private MethodColumn methodColumn;
    private final ProfilingSession session;
    private int size;

    public ParameterColumn(ProfilingSession session) {
        this.session = session;
        this.type = null;
    }

    @Override
    public void fromList(List<Parameter> list) {
        this.size = list.size();
        int start = 0;
        ArrayList<Parameter> directParameters = new ArrayList<Parameter>();
        for (int i = this.size - 1; i >= 0; --i) {
            if (list.get(i).isErrorType()) {
                directParameters.add(list.get(i));
                if (start != 0) continue;
                start = i + 1;
                continue;
            }
            if (start == 0) continue;
            directParameters.add(list.get(i));
        }
        Collections.reverse(directParameters);
        this.parameters = directParameters.toArray(new Parameter[directParameters.size()]);
        if (start == this.size) {
            return;
        }
        this.type = list.get(start).getType();
        switch (this.type) {
            case BOOLEAN: {
                this.setBooleans(list, start);
                break;
            }
            case BYTE: {
                this.setBytes(list, start);
                break;
            }
            case SHORT: {
                this.setShorts(list, start);
                break;
            }
            case CHAR: {
                this.setChars(list, start);
                break;
            }
            case INT: {
                this.setInts(list, start);
                break;
            }
            case LONG: {
                this.setLongs(list, start);
                break;
            }
            case FLOAT: {
                this.setFloats(list, start);
                break;
            }
            case DOUBLE: {
                this.setDoubles(list, start);
                break;
            }
            case STRING: {
                this.setStrings(list, start);
                break;
            }
            case CLASS: {
                this.setClasses(list, start);
                break;
            }
            case METHOD: {
                this.setMethods(list, start);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void setLongValues(long[] values) {
        this.longColumn = new LongColumnBase(1);
        long[][] toFill = this.longColumn.setNrOfRows(values.length);
        toFill[0] = values;
        this.longColumn.convertColumnIfPossible(0);
    }

    private void setBooleans(List<Parameter> list, int start) {
        long[] values = new long[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            values[i - start] = ((BooleanParameter)list.get(i)).getValue() ? 1L : 0L;
        }
        this.setLongValues(values);
    }

    private void setBytes(List<Parameter> list, int start) {
        long[] values = new long[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            values[i - start] = ((ByteParameter)list.get(i)).getValue();
        }
        this.setLongValues(values);
    }

    private void setShorts(List<Parameter> list, int start) {
        long[] values = new long[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            values[i - start] = ((ShortParameter)list.get(i)).getValue();
        }
        this.setLongValues(values);
    }

    private void setChars(List<Parameter> list, int start) {
        long[] values = new long[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            values[i - start] = ((CharParameter)list.get(i)).getValue();
        }
        this.setLongValues(values);
    }

    private void setInts(List<Parameter> list, int start) {
        long[] values = new long[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            values[i - start] = ((IntParameter)list.get(i)).getValue();
        }
        this.setLongValues(values);
    }

    private void setLongs(List<Parameter> list, int start) {
        long[] values = new long[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            values[i - start] = ((LongParameter)list.get(i)).getValue();
        }
        this.setLongValues(values);
    }

    private void setFloats(List<Parameter> list, int start) {
        this.floatColumn = new float[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            this.floatColumn[i - start] = ((FloatParameter)list.get(i)).getValue();
        }
    }

    private void setDoubles(List<Parameter> list, int start) {
        this.doubleColumn = new double[list.size() - start];
        for (int i = start; i < list.size(); ++i) {
            this.doubleColumn[i - start] = ((DoubleParameter)list.get(i)).getValue();
        }
    }

    private void setStrings(final List<Parameter> list, final int start) {
        this.stringColumn = new UTF8StringColumn();
        this.stringColumn.fromList((List<UTF8String>)new AbstractList<UTF8String>(){

            @Override
            public UTF8String get(int index) {
                return UTF8Creator.create((byte[])((StringParameter)list.get(index + start)).getUTF());
            }

            @Override
            public int size() {
                return list.size() - start;
            }
        });
    }

    private void setClasses(final List<Parameter> list, final int start) {
        this.classColumn = new ClassColumn(this.session);
        this.classColumn.fromList((List<ClassObject>)new AbstractList<ClassObject>(){

            @Override
            public ClassObject get(int index) {
                return ((ClassParameter)list.get(index + start)).getValue();
            }

            @Override
            public int size() {
                return list.size() - start;
            }
        });
    }

    private void setMethods(final List<Parameter> list, final int start) {
        this.methodColumn = new MethodColumn(this.session);
        this.methodColumn.fromList((List<MethodObject>)new AbstractList<MethodObject>(){

            @Override
            public MethodObject get(int index) {
                return ((MethodParameter)list.get(index + start)).getMethod();
            }

            @Override
            public int size() {
                return list.size() - start;
            }
        });
        this.classColumn = new ClassColumn(this.session);
        this.classColumn.fromList((List<ClassObject>)new AbstractList<ClassObject>(){

            @Override
            public ClassObject get(int index) {
                return ((MethodParameter)list.get(index + start)).getReceiverClass();
            }

            @Override
            public int size() {
                return list.size() - start;
            }
        });
    }

    @Override
    public Parameter get(int index) {
        if (index < this.parameters.length) {
            return this.parameters[index];
        }
        if (this.longColumn != null) {
            long raw = this.longColumn.getValue(0, index - this.parameters.length);
            switch (this.type) {
                case BOOLEAN: {
                    return new BooleanParameter(raw != 0L);
                }
                case BYTE: {
                    return new ByteParameter((byte)raw);
                }
                case SHORT: {
                    return new ShortParameter((short)raw);
                }
                case CHAR: {
                    return new CharParameter((char)raw);
                }
                case INT: {
                    return new IntParameter((int)raw);
                }
                case LONG: {
                    return new LongParameter(raw);
                }
            }
        } else {
            if (this.stringColumn != null) {
                assert (this.type == ParameterType.STRING);
                return new StringParameter(this.stringColumn.get(index - this.parameters.length).getBytes());
            }
            if (this.methodColumn != null) {
                assert (this.type == ParameterType.METHOD);
                return new MethodParameter(this.methodColumn.get(index - this.parameters.length), this.classColumn.get(index - this.parameters.length));
            }
            if (this.classColumn != null) {
                assert (this.type == ParameterType.CLASS);
                return new ClassParameter(this.classColumn.get(index - this.parameters.length));
            }
            if (this.floatColumn != null) {
                assert (this.type == ParameterType.FLOAT);
                return new FloatParameter(this.floatColumn[index - this.parameters.length]);
            }
        }
        assert (this.doubleColumn != null);
        assert (this.type == ParameterType.DOUBLE);
        return new DoubleParameter(this.doubleColumn[index - this.parameters.length]);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        final Parameter[] params = new Parameter[reader.readInt32()];
        for (int i = 0; i < params.length; ++i) {
            reporter.reportNextOrThrow();
            params[i] = Parameter.read((ResourceReader)reader);
        }
        this.fromList((List<Parameter>)new AbstractList<Parameter>(){

            @Override
            public Parameter get(int index) {
                return params[index];
            }

            @Override
            public int size() {
                return params.length;
            }
        });
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeInt32(this.size);
        for (int i = 0; i < this.size; ++i) {
            reporter.reportNextOrThrow();
            this.get(i).write(writer);
        }
    }

    @Override
    public long getWork(int dummy) {
        return this.size;
    }
}

