/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.resource.SocketId;
import java.io.IOException;
import java.util.List;

public class SocketIdColumn
implements SerializableColumn<SocketId> {
    private static final int VERSION = 0;
    private SocketId[] socketIds = new SocketId[0];

    @Override
    public void fromList(List<SocketId> list) {
        this.socketIds = list.toArray(new SocketId[list.size()]);
    }

    @Override
    public SocketId get(int index) {
        return this.socketIds[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.socketIds = new SocketId[reader.readInt32()];
        for (int i = 0; i < this.socketIds.length; ++i) {
            reporter.reportNextOrThrow();
            this.socketIds[i] = new SocketId(reader);
        }
    }

    @Override
    public int size() {
        return this.socketIds.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.socketIds.length);
        for (SocketId socketId : this.socketIds) {
            reporter.reportNextOrThrow();
            socketId.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

