/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import java.io.IOException;
import java.util.List;

public class StringColumn
implements SerializableColumn<String> {
    private static final int VERSION = 0;
    private String[] strings = new String[0];

    @Override
    public void fromList(List<String> list) {
        this.strings = list.toArray(new String[list.size()]);
    }

    @Override
    public String get(int index) {
        return this.strings[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.strings = new String[reader.readInt32()];
        for (int i = 0; i < this.strings.length; ++i) {
            reporter.reportNextOrThrow();
            this.strings[i] = reader.readString();
        }
    }

    @Override
    public int size() {
        return this.strings.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.strings.length);
        for (String str : this.strings) {
            reporter.reportNextOrThrow();
            writer.writeString(str);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

