/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import java.io.IOException;
import java.util.List;

public class SynchronizationEventIdColumn
implements SerializableColumn<SynchronizationEventId> {
    private static final int VERSION = 0;
    private SynchronizationEventId[] ids;

    @Override
    public void fromList(List<SynchronizationEventId> list) {
        this.ids = list.toArray(new SynchronizationEventId[list.size()]);
    }

    @Override
    public SynchronizationEventId get(int index) {
        return this.ids[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.ids = new SynchronizationEventId[reader.readInt32()];
        for (int i = 0; i < this.ids.length; ++i) {
            reporter.reportNextOrThrow();
            this.ids[i] = new SynchronizationEventId(reader);
        }
    }

    @Override
    public int size() {
        return this.ids.length;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.ids.length);
        for (SynchronizationEventId id : this.ids) {
            reporter.reportNextOrThrow();
            id.write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }
}

