/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValuesColumn;
import com.sap.jvm.profiling.thread.ThreadDump;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ThreadDumpValuesColumnImpl
implements SerializableColumn<ThreadDumpValue>,
ThreadDumpValuesColumn {
    private static final int VERSION = 0;
    List<ThreadDumpValue> threadValues = new ArrayList<ThreadDumpValue>();
    ThreadDump threadDump;

    @Override
    public int size() {
        return this.threadValues.size();
    }

    @Override
    public void fromList(List<ThreadDumpValue> list) {
        this.threadValues = new ArrayList<ThreadDumpValue>(list);
    }

    @Override
    public ThreadDumpValue get(int index) {
        return this.threadValues.get(index);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        int numThreads = reader.readInt32();
        for (int i = 0; i < numThreads; ++i) {
            reporter.reportNextOrThrow();
            this.threadValues.add(new ThreadDumpValueImpl(reader, this.threadDump, null));
        }
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.threadValues.size());
        for (ThreadDumpValue threadDumpValue : this.threadValues) {
            reporter.reportNextOrThrow();
            ((ThreadDumpValueImpl)threadDumpValue).write(writer);
        }
    }

    @Override
    public long getWork(int size) {
        return this.threadValues.size();
    }
}

