/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndName;
import com.sap.jvm.profiling.snapshot.resource.ThreadIdAndNameColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class ThreadIdAndNameColumnImpl
extends LongColumnBase
implements SerializableColumn<ThreadIdAndName>,
ThreadIdAndNameColumn {
    private static final int VERSION = 1;
    private final LongValueColumnImpl ids = new LongValueColumnImpl(this, 0);
    private final UTF8StringColumn names = new UTF8StringColumn();

    public ThreadIdAndNameColumnImpl() {
        super(1);
    }

    @Override
    public void fromList(List<ThreadIdAndName> list) {
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getId();
        }
        this.convertColumnIfPossible(0);
        UTF8String[] strings = new UTF8String[nrOfRows];
        for (int i = 0; i < nrOfRows; ++i) {
            strings[i] = list.get(i).getUTFName();
        }
        this.names.setList(strings);
    }

    @Override
    public ThreadIdAndName get(int index) {
        return new ThreadIdAndName(this.getValue(0, index), this.names.get(index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        this.readColumns(reader, reporter);
        this.names.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        this.writeColumns(writer, reporter);
        this.names.write(writer, reporter);
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + this.names.getWork(size);
    }

    @Override
    public LongValueColumn getIdColumn() {
        return this.ids;
    }

    @Override
    public UTF8StringColumn getNameColumn() {
        return this.names;
    }
}

