/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCountColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class TimeAndCountColumnImpl
extends LongColumnBase
implements SerializableColumn<TimeAndCount>,
TimeAndCountColumn {
    private static final int VERSION = 0;
    private static final int TIME_COLUMN = 0;
    private static final int COUNT_COLUMN = 1;
    private static final int NR_OF_COLUMNS = 2;
    private final LongValueColumnImpl timeColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl countColumn = new LongValueColumnImpl(this, 1);

    public TimeAndCountColumnImpl() {
        super(2);
    }

    @Override
    public void fromList(List<TimeAndCount> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getDuration();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getCount();
        }
        this.convertColumnIfPossible(1);
    }

    @Override
    public TimeAndCount get(int index) {
        return new TimeAndCount(this.getValue(0, index), this.getValue(1, index));
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getCountColumn() {
        return this.countColumn;
    }

    @Override
    public LongValueColumn getTimeColumn() {
        return this.timeColumn;
    }
}

