/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeDistColumnImpl;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDistColumn;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDistColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.AbstractList;
import java.util.List;

public class TimeAndDistColumnImpl
extends LongColumnBase
implements SerializableColumn<TimeAndDist>,
TimeAndDistColumn {
    private static final int VERSION = 3;
    private static final int TIME_COLUMN = 0;
    private static final int CPU_TIME_COLUMN = 1;
    private static final int SLEEPING_TIME_COLUMN = 2;
    private static final int NR_OF_COLUMNS = 3;
    private final LongValueColumn elapsedTimeColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumn cpuTimeColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumn sleepingTimeColumn = new LongValueColumnImpl(this, 2);
    private final TimeDistColumnImpl elapsedDistColumn = new TimeDistColumnImpl();
    private final TimeDistColumnImpl cpuDistColumn = new TimeDistColumnImpl();

    public TimeAndDistColumnImpl() {
        super(3);
    }

    @Override
    public void fromList(final List<TimeAndDist> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getTime();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getCpuTime();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getSleepingTime();
        }
        this.convertColumnIfPossible(2);
        this.elapsedDistColumn.fromList((List<TimeDist>)new AbstractList<TimeDist>(){

            @Override
            public TimeDist get(int index) {
                return ((TimeAndDist)list.get(index)).getTimeDistribution();
            }

            @Override
            public int size() {
                return list.size();
            }
        });
        this.cpuDistColumn.fromList((List<TimeDist>)new AbstractList<TimeDist>(){

            @Override
            public TimeDist get(int index) {
                return ((TimeAndDist)list.get(index)).getCpuTimeDistribution();
            }

            @Override
            public int size() {
                return list.size();
            }
        });
    }

    @Override
    public TimeAndDist get(int index) {
        return new ColumnTimeAndDist(this, index);
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(3);
        this.readColumns(reader, reporter);
        this.elapsedDistColumn.read(reader, reporter);
        this.cpuDistColumn.read(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(3);
        this.writeColumns(writer, reporter);
        this.elapsedDistColumn.write(writer, reporter);
        this.cpuDistColumn.write(writer, reporter);
    }

    @Override
    public LongValueColumn getCpuTimeColumn() {
        return this.cpuTimeColumn;
    }

    @Override
    public TimeDistColumn getCpuTimeDistributionColumn() {
        return this.cpuDistColumn;
    }

    @Override
    public LongValueColumn getSleepingTimeColumn() {
        return this.sleepingTimeColumn;
    }

    @Override
    public LongValueColumn getTimeColumn() {
        return this.elapsedTimeColumn;
    }

    @Override
    public TimeDistColumn getTimeDistributionColumn() {
        return this.elapsedDistColumn;
    }

    @Override
    public long getWork(int size) {
        return super.getWork(size) + this.elapsedDistColumn.getWork(size) + this.cpuDistColumn.getWork(size);
    }

    private static final class ColumnTimeAndDist
    implements TimeAndDist {
        private final TimeAndDistColumnImpl column;
        private final int row;

        public ColumnTimeAndDist(TimeAndDistColumnImpl column, int row) {
            this.column = column;
            this.row = row;
        }

        @Override
        public long getCpuTime() {
            return this.column.getValue(1, this.row);
        }

        @Override
        public TimeDist getCpuTimeDistribution() {
            return this.column.cpuDistColumn.get(this.row);
        }

        @Override
        public long getMaxTime() {
            return Math.max(this.getTime(), this.getCpuTime()) + this.getSleepingTime();
        }

        @Override
        public long getSleepingTime() {
            return this.column.getValue(2, this.row);
        }

        @Override
        public TimeAndDist getSum(TimeAndDist toAdd) {
            return new SimpleTimeAndDist(this).getSum(toAdd);
        }

        @Override
        public long getTime() {
            return this.column.getValue(0, this.row);
        }

        @Override
        public TimeDist getTimeDistribution() {
            return this.column.elapsedDistColumn.get(this.row);
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            new SimpleTimeAndDist(this).write(writer);
        }
    }
}

