/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TotalLongValueColumn;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDistColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import java.io.IOException;
import java.util.List;

public class TimeDistColumnImpl
extends LongColumnBase
implements SerializableColumn<TimeDist>,
TimeDistColumn {
    private static final int VERSION = 2;
    private static final int INTERPRETER_TIME_COLUMN = 0;
    private static final int NATIVE_INTERPRETER_TIME_COLUMN = 1;
    private static final int INLINED_TIME_COLUMN = 2;
    private static final int NATIVE_INLINED_TIME_COLUMN = 3;
    private static final int COMPILED_TIME_COLUMN = 4;
    private static final int NATIVE_COMPILED_TIME_COLUMN = 5;
    private static final int INLINED_TIER_1_TIME_COLUMN = 6;
    private static final int NATIVE_INLINED_TIER_1_TIME_COLUMN = 7;
    private static final int COMPILED_TIER_1_TIME_COLUMN = 8;
    private static final int NATIVE_COMPILED_TIER_1_TIME_COLUMN = 9;
    private static final int OTHER_TIME_COLUMN = 10;
    private static final int NR_OF_COLUMNS = 11;
    private final LongValueColumnImpl interpertedColumn = new LongValueColumnImpl(this, 0);
    private final LongValueColumnImpl nativeInterpertedColumn = new LongValueColumnImpl(this, 1);
    private final LongValueColumnImpl compiledColumn = new LongValueColumnImpl(this, 4);
    private final LongValueColumnImpl nativeCompiledColumn = new LongValueColumnImpl(this, 5);
    private final LongValueColumnImpl inlinedColumn = new LongValueColumnImpl(this, 2);
    private final LongValueColumnImpl nativeInlinedColumn = new LongValueColumnImpl(this, 3);
    private final LongValueColumnImpl compiledTier1Column = new LongValueColumnImpl(this, 8);
    private final LongValueColumnImpl nativeCompiledTier1Column = new LongValueColumnImpl(this, 9);
    private final LongValueColumnImpl inlinedTier1Column = new LongValueColumnImpl(this, 6);
    private final LongValueColumnImpl nativeInlinedTier1Column = new LongValueColumnImpl(this, 7);
    private final LongValueColumnImpl otherColumn = new LongValueColumnImpl(this, 10);
    private final TotalLongValueColumn totalColumn = new TotalLongValueColumn(this);

    public TimeDistColumnImpl() {
        super(11);
    }

    @Override
    public void fromList(List<TimeDist> list) {
        int i;
        int nrOfRows = list.size();
        long[][] values = this.setNrOfRows(nrOfRows);
        values[0] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[0][i] = list.get(i).getInterpreterTime();
        }
        this.convertColumnIfPossible(0);
        values[1] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[1][i] = list.get(i).getNativeInterpreterTime();
        }
        this.convertColumnIfPossible(1);
        values[2] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[2][i] = list.get(i).getInlinedTime();
        }
        this.convertColumnIfPossible(2);
        values[3] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[3][i] = list.get(i).getNativeInlinedTime();
        }
        this.convertColumnIfPossible(3);
        values[4] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[4][i] = list.get(i).getCompiledTime();
        }
        this.convertColumnIfPossible(4);
        values[5] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[5][i] = list.get(i).getNativeCompiledTime();
        }
        this.convertColumnIfPossible(5);
        values[6] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[6][i] = list.get(i).getInlinedTier1Time();
        }
        this.convertColumnIfPossible(6);
        values[7] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[7][i] = list.get(i).getNativeInlinedTier1Time();
        }
        this.convertColumnIfPossible(7);
        values[8] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[8][i] = list.get(i).getCompiledTier1Time();
        }
        this.convertColumnIfPossible(8);
        values[9] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[9][i] = list.get(i).getNativeCompiledTier1Time();
        }
        this.convertColumnIfPossible(9);
        values[10] = new long[nrOfRows];
        for (i = 0; i < nrOfRows; ++i) {
            values[10][i] = list.get(i).getOtherTime();
        }
        this.createNonZeroColumnInfo();
    }

    @Override
    public TimeDist get(final int index) {
        return new TimeDist(){

            @Override
            public void write(ResourceWriter writer) throws IOException {
                new SimpleTimeDist(this).write(writer);
            }

            @Override
            public long getTotalTime() {
                return TimeDistColumnImpl.this.totalColumn.get(index);
            }

            @Override
            public TimeDist getSum(TimeDist toAdd) {
                return new SimpleTimeDist(this).getSum(toAdd);
            }

            @Override
            public long getOtherTime() {
                return TimeDistColumnImpl.this.otherColumn.get(index);
            }

            @Override
            public long getNativeInterpreterTime() {
                return TimeDistColumnImpl.this.nativeInterpertedColumn.get(index);
            }

            @Override
            public long getNativeInlinedTime() {
                return TimeDistColumnImpl.this.nativeInlinedColumn.get(index);
            }

            @Override
            public long getNativeInlinedTier1Time() {
                return TimeDistColumnImpl.this.nativeInlinedTier1Column.get(index);
            }

            @Override
            public long getNativeCompiledTime() {
                return TimeDistColumnImpl.this.nativeCompiledColumn.get(index);
            }

            @Override
            public long getNativeCompiledTier1Time() {
                return TimeDistColumnImpl.this.nativeCompiledTier1Column.get(index);
            }

            @Override
            public long getInterpreterTime() {
                return TimeDistColumnImpl.this.interpertedColumn.get(index);
            }

            @Override
            public long getInlinedTime() {
                return TimeDistColumnImpl.this.inlinedColumn.get(index);
            }

            @Override
            public long getInlinedTier1Time() {
                return TimeDistColumnImpl.this.inlinedTier1Column.get(index);
            }

            @Override
            public long getCompiledTime() {
                return TimeDistColumnImpl.this.compiledColumn.get(index);
            }

            @Override
            public long getCompiledTier1Time() {
                return TimeDistColumnImpl.this.compiledTier1Column.get(index);
            }
        };
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.readColumns(reader, reporter);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        this.writeColumns(writer, reporter);
    }

    @Override
    public LongValueColumn getCompiledTier1TimeColumn() {
        return this.compiledTier1Column;
    }

    @Override
    public LongValueColumn getCompiledTimeColumn() {
        return this.compiledColumn;
    }

    @Override
    public LongValueColumn getInlinedTier1TimeColumn() {
        return this.inlinedTier1Column;
    }

    @Override
    public LongValueColumn getInlinedTimeColumn() {
        return this.inlinedColumn;
    }

    @Override
    public LongValueColumn getInterpreterTimeColumn() {
        return this.interpertedColumn;
    }

    @Override
    public LongValueColumn getNativeCompiledTier1TimeColumn() {
        return this.nativeCompiledTier1Column;
    }

    @Override
    public LongValueColumn getNativeCompiledTimeColumn() {
        return this.nativeCompiledColumn;
    }

    @Override
    public LongValueColumn getNativeInlinedTier1TimeColumn() {
        return this.nativeInlinedTier1Column;
    }

    @Override
    public LongValueColumn getNativeInlinedTimeColumn() {
        return this.nativeInlinedColumn;
    }

    @Override
    public LongValueColumn getNativeInterpreterTimeColumn() {
        return this.nativeInterpertedColumn;
    }

    @Override
    public LongValueColumn getOtherTimeColumn() {
        return this.otherColumn;
    }

    @Override
    public LongValueColumn getTotalTimeColumn() {
        return this.totalColumn;
    }
}

