/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.snapshot.util.column.LongColumnBase;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumn;
import com.sap.jvm.profiling.snapshot.util.column.LongValueColumnImpl;
import com.sap.jvm.profiling.snapshot.util.column.SortableColumn;

public class TotalLongValueColumn
implements LongValueColumn,
SortableColumn {
    private final LongColumnBase base;

    public TotalLongValueColumn(LongColumnBase base) {
        this.base = base;
    }

    @Override
    public long get(int index) {
        return this.base.getTotalValue(index);
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public long getMaxValue() {
        return this.asLongValueColumn().getMaxValue();
    }

    @Override
    public long getMinValue() {
        return this.asLongValueColumn().getMinValue();
    }

    @Override
    public int[] sortAscending(int[] initialOrder, int nrOfThreads) {
        return this.asLongValueColumn().sortAscending(initialOrder, nrOfThreads);
    }

    @Override
    public int[] sortDescending(int[] initialOrder, int nrOfThreads) {
        return this.asLongValueColumn().sortDescending(initialOrder, nrOfThreads);
    }

    private LongValueColumnImpl asLongValueColumn() {
        LongColumnBase newBase = new LongColumnBase(1);
        long[][] valuesArray = newBase.setNrOfRows(this.size());
        valuesArray[0] = new long[this.size()];
        long[] totals = valuesArray[0];
        for (int i = 0; i < totals.length; ++i) {
            totals[i] = this.base.getTotalValue(i);
        }
        newBase.convertColumnIfPossible(0);
        newBase.createNonZeroColumnInfo();
        return new LongValueColumnImpl(newBase, 0);
    }
}

