/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.column;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.util.column.SortableColumn;
import com.sap.jvm.profiling.snapshot.util.column.UniqueSortableColumn;
import com.sap.jvm.util.misc.UTF8Util;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.IOException;
import java.util.List;

public class UTF8StringColumn
implements SerializableColumn<UTF8String>,
SortableColumn,
UniqueSortableColumn {
    private static final int VERSION = 0;
    private static final int CHUNK_SIZE = 0x100000;
    private static final int MAX_WASTE = 1024;
    private int nrOfRows;
    private UTF8String[] strings;
    private int[] offsets;
    private long[] longOffsets;
    private char[] lengths;
    private byte[][] bytes;
    private final boolean forceLongOffsets;

    public UTF8StringColumn(boolean keepObjects, boolean forceLongOffsets) {
        if (keepObjects) {
            this.strings = new UTF8String[0];
        }
        this.forceLongOffsets = forceLongOffsets;
    }

    public UTF8StringColumn() {
        this(false, false);
    }

    @Override
    public void fromList(List<UTF8String> list) {
        this.setList(list.toArray(new UTF8String[list.size()]));
    }

    public void setList(UTF8String[] list) {
        this.nrOfRows = list.length;
        if (this.strings != null) {
            this.strings = list;
            return;
        }
        if (this.forceLongOffsets) {
            this.longOffsets = new long[this.nrOfRows];
        } else {
            this.offsets = new int[this.nrOfRows];
        }
        this.lengths = new char[this.nrOfRows];
        this.bytes = new byte[1][];
        this.bytes[0] = new byte[0x100000];
        long offset = 0L;
        int chunkIndex = 0;
        int chunkOffset = 0;
        for (int i = 0; i < this.nrOfRows; ++i) {
            UTF8String str = list[i];
            int len = str.length();
            list[i] = null;
            assert (len < 65536);
            this.lengths[i] = (char)len;
            if (chunkOffset + len > 0x100000) {
                int waste = 0x100000 - chunkOffset;
                if (waste > 1024) {
                    byte[] newChunk = new byte[chunkOffset];
                    System.arraycopy(this.bytes[chunkIndex], 0, newChunk, 0, chunkOffset);
                    this.bytes[chunkIndex] = newChunk;
                }
                offset += (long)waste;
                chunkOffset = 0;
                if (++chunkIndex >= this.bytes.length) {
                    byte[][] newBytes = new byte[this.bytes.length * 2][];
                    System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
                    this.bytes = newBytes;
                }
                this.bytes[chunkIndex] = new byte[0x100000];
                if (this.longOffsets == null && offset > Integer.MAX_VALUE) {
                    assert ((this.bytes[chunkIndex].length & this.bytes[chunkIndex].length - 1) == 0);
                    this.longOffsets = new long[this.nrOfRows];
                    for (int j = 0; j < i; ++j) {
                        this.longOffsets[j] = this.offsets[i];
                    }
                    this.offsets = null;
                }
            }
            if (this.offsets == null) {
                this.longOffsets[i] = offset;
            } else {
                this.offsets[i] = (int)offset;
            }
            System.arraycopy(str.getBytes(), 0, this.bytes[chunkIndex], chunkOffset, len);
            offset += (long)len;
            chunkOffset += len;
        }
        int waste = 0x100000 - chunkOffset;
        if (waste > 1024) {
            byte[] newChunk = new byte[chunkOffset];
            System.arraycopy(this.bytes[chunkIndex], 0, newChunk, 0, chunkOffset);
            this.bytes[chunkIndex] = newChunk;
        }
    }

    @Override
    public UTF8String get(int index) {
        if (this.offsets != null) {
            int offset = this.offsets[index];
            int chunkIndex = offset / 0x100000;
            int chunkOffset = offset & 0xFFFFF;
            return UTF8Creator.create((byte[])this.bytes[chunkIndex], (int)chunkOffset, (int)this.lengths[index]);
        }
        if (this.longOffsets != null) {
            long offset = this.longOffsets[index];
            int chunkIndex = (int)(offset / 0x100000L);
            int chunkOffset = (int)(offset & 0xFFFFFL);
            return UTF8Creator.create((byte[])this.bytes[chunkIndex], (int)chunkOffset, (int)this.lengths[index]);
        }
        return this.strings[index];
    }

    @Override
    public void read(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0);
        UTF8String[] readStrings = new UTF8String[reader.readInt32()];
        for (int i = 0; i < readStrings.length; ++i) {
            reporter.reportNextOrThrow();
            readStrings[i] = reader.readUTF();
        }
        this.setList(readStrings);
    }

    @Override
    public int size() {
        return this.nrOfRows;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.nrOfRows);
        if (this.strings != null) {
            for (UTF8String string : this.strings) {
                reporter.reportNextOrThrow();
                writer.writeUTF(string);
            }
        } else if (this.offsets != null) {
            for (int i = 0; i < this.nrOfRows; ++i) {
                reporter.reportNextOrThrow();
                int offset = this.offsets[i];
                int chunkIndex = offset / 0x100000;
                int chunkOffset = offset & 0xFFFFF;
                writer.writeUTF(this.bytes[chunkIndex], chunkOffset, (int)this.lengths[i]);
            }
        } else {
            for (int i = 0; i < this.nrOfRows; ++i) {
                reporter.reportNextOrThrow();
                long offset = this.longOffsets[i];
                int chunkIndex = (int)(offset / 0x100000L);
                int chunkOffset = (int)(offset & 0xFFFFFL);
                writer.writeUTF(this.bytes[chunkIndex], chunkOffset, (int)this.lengths[i]);
            }
        }
    }

    @Override
    public long getWork(int size) {
        return size;
    }

    @Override
    public int[] sortAscending(int[] initialOrder, int nrOfThreads) {
        if (this.strings != null) {
            this.mergeSortAscendingIgnoreCaseString(initialOrder, 0, initialOrder.length, nrOfThreads);
        } else if (this.offsets != null) {
            this.mergeSortAscendingIgnoreCaseInt(initialOrder, 0, initialOrder.length, nrOfThreads);
        } else {
            this.mergeSortAscendingIgnoreCaseLong(initialOrder, 0, initialOrder.length, nrOfThreads);
        }
        return initialOrder;
    }

    @Override
    public int[] sortDescending(int[] initialOrder, int nrOfThreads) {
        if (this.strings != null) {
            this.mergeSortDescendingIgnoreCaseString(initialOrder, 0, initialOrder.length, nrOfThreads);
        } else if (this.offsets != null) {
            this.mergeSortDescendingIgnoreCaseInt(initialOrder, 0, initialOrder.length, nrOfThreads);
        } else {
            this.mergeSortDescendingIgnoreCaseLong(initialOrder, 0, initialOrder.length, nrOfThreads);
        }
        return initialOrder;
    }

    @Override
    public int[] sortUnique(int[] initialOrder, int nrOfThreads) {
        if (this.strings != null) {
            this.mergeSortAscendingString(initialOrder, 0, initialOrder.length, nrOfThreads);
        } else if (this.offsets != null) {
            this.mergeSortAscendingInt(initialOrder, 0, initialOrder.length, nrOfThreads);
        } else {
            this.mergeSortAscendingLong(initialOrder, 0, initialOrder.length, nrOfThreads);
        }
        return initialOrder;
    }

    private void mergeSortAscendingString(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                UTF8String v1 = this.strings[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    UTF8String v2 = this.strings[in[mid]];
                    if (v1.compareTo((Object)v2) >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortAscendingString(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingString(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingString(in, from, mid, nrOfThreads);
            this.mergeSortAscendingString(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        UTF8String v1 = this.strings[copy[p1]];
        UTF8String v2 = this.strings[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1.compareTo((Object)v2) <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = this.strings[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = this.strings[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingInt(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                int offset1 = this.offsets[in[i]];
                int chunkIndex1 = offset1 / 0x100000;
                int chunkOffset1 = offset1 & 0xFFFFF;
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    int offset2 = this.offsets[in[mid]];
                    int chunkIndex2 = offset2 / 0x100000;
                    int chunkOffset2 = offset2 & 0xFFFFF;
                    int cmp = UTF8Util.compare((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[in[i]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[mid]]);
                    if (cmp >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortAscendingInt(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingInt(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingInt(in, from, mid, nrOfThreads);
            this.mergeSortAscendingInt(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        int offset1 = this.offsets[copy[p1]];
        int chunkIndex1 = offset1 / 0x100000;
        int chunkOffset1 = offset1 & 0xFFFFF;
        int offset2 = this.offsets[in[p2]];
        int chunkIndex2 = offset2 / 0x100000;
        int chunkOffset2 = offset2 & 0xFFFFF;
        for (int i = from; i < to; ++i) {
            int cmp = UTF8Util.compare((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[copy[p1]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[p2]]);
            if (cmp <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    offset1 = this.offsets[copy[p1]];
                    chunkIndex1 = offset1 / 0x100000;
                    chunkOffset1 = offset1 & 0xFFFFF;
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                offset2 = this.offsets[in[p2]];
                chunkIndex2 = offset2 / 0x100000;
                chunkOffset2 = offset2 & 0xFFFFF;
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingLong(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long offset1 = this.longOffsets[in[i]];
                int chunkIndex1 = (int)(offset1 / 0x100000L);
                int chunkOffset1 = (int)(offset1 & 0xFFFFFL);
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    long offset2 = this.longOffsets[in[mid]];
                    int chunkIndex2 = (int)(offset2 / 0x100000L);
                    int chunkOffset2 = (int)(offset2 & 0xFFFFFL);
                    int cmp = UTF8Util.compare((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[in[i]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[mid]]);
                    if (cmp >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortAscendingLong(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingLong(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingLong(in, from, mid, nrOfThreads);
            this.mergeSortAscendingLong(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long offset1 = this.longOffsets[copy[p1]];
        int chunkIndex1 = (int)(offset1 / 0x100000L);
        int chunkOffset1 = (int)(offset1 & 0xFFFFFL);
        long offset2 = this.longOffsets[in[p2]];
        int chunkIndex2 = (int)(offset2 / 0x100000L);
        int chunkOffset2 = (int)(offset2 & 0xFFFFFL);
        for (int i = from; i < to; ++i) {
            int cmp = UTF8Util.compare((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[copy[p1]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[p2]]);
            if (cmp <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    offset1 = this.longOffsets[copy[p1]];
                    chunkIndex1 = (int)(offset1 / 0x100000L);
                    chunkOffset1 = (int)(offset1 & 0xFFFFFL);
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                offset2 = this.longOffsets[in[p2]];
                chunkIndex2 = (int)(offset2 / 0x100000L);
                chunkOffset2 = (int)(offset2 & 0xFFFFFL);
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingIgnoreCaseString(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                UTF8String v1 = this.strings[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    UTF8String v2 = this.strings[in[mid]];
                    if (v1.compareForCaseInsenstiveOrder(v2) >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortAscendingIgnoreCaseString(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingIgnoreCaseString(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingIgnoreCaseString(in, from, mid, nrOfThreads);
            this.mergeSortAscendingIgnoreCaseString(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        UTF8String v1 = this.strings[copy[p1]];
        UTF8String v2 = this.strings[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1.compareForCaseInsenstiveOrder(v2) <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = this.strings[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = this.strings[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortDescendingIgnoreCaseString(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                UTF8String v1 = this.strings[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    UTF8String v2 = this.strings[in[mid]];
                    if (v1.compareForCaseInsenstiveOrder(v2) <= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortDescendingIgnoreCaseString(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortDescendingIgnoreCaseString(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescendingIgnoreCaseString(in, from, mid, nrOfThreads);
            this.mergeSortDescendingIgnoreCaseString(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        UTF8String v1 = this.strings[copy[p1]];
        UTF8String v2 = this.strings[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1.compareForCaseInsenstiveOrder(v2) >= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = this.strings[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = this.strings[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingIgnoreCaseInt(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                int offset1 = this.offsets[in[i]];
                int chunkIndex1 = offset1 / 0x100000;
                int chunkOffset1 = offset1 & 0xFFFFF;
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    int offset2 = this.offsets[in[mid]];
                    int chunkIndex2 = offset2 / 0x100000;
                    int chunkOffset2 = offset2 & 0xFFFFF;
                    int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[in[i]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[mid]]);
                    if (cmp >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortAscendingIgnoreCaseInt(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingIgnoreCaseInt(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingIgnoreCaseInt(in, from, mid, nrOfThreads);
            this.mergeSortAscendingIgnoreCaseInt(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        int offset1 = this.offsets[copy[p1]];
        int chunkIndex1 = offset1 / 0x100000;
        int chunkOffset1 = offset1 & 0xFFFFF;
        int offset2 = this.offsets[in[p2]];
        int chunkIndex2 = offset2 / 0x100000;
        int chunkOffset2 = offset2 & 0xFFFFF;
        for (int i = from; i < to; ++i) {
            int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[copy[p1]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[p2]]);
            if (cmp <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    offset1 = this.offsets[copy[p1]];
                    chunkIndex1 = offset1 / 0x100000;
                    chunkOffset1 = offset1 & 0xFFFFF;
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                offset2 = this.offsets[in[p2]];
                chunkIndex2 = offset2 / 0x100000;
                chunkOffset2 = offset2 & 0xFFFFF;
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortDescendingIgnoreCaseInt(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                int offset1 = this.offsets[in[i]];
                int chunkIndex1 = offset1 / 0x100000;
                int chunkOffset1 = offset1 & 0xFFFFF;
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    int offset2 = this.offsets[in[mid]];
                    int chunkIndex2 = offset2 / 0x100000;
                    int chunkOffset2 = offset2 & 0xFFFFF;
                    int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[in[i]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[mid]]);
                    if (cmp <= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortDescendingIgnoreCaseInt(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortDescendingIgnoreCaseInt(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescendingIgnoreCaseInt(in, from, mid, nrOfThreads);
            this.mergeSortDescendingIgnoreCaseInt(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        int offset1 = this.offsets[copy[p1]];
        int chunkIndex1 = offset1 / 0x100000;
        int chunkOffset1 = offset1 & 0xFFFFF;
        int offset2 = this.offsets[in[p2]];
        int chunkIndex2 = offset2 / 0x100000;
        int chunkOffset2 = offset2 & 0xFFFFF;
        for (int i = from; i < to; ++i) {
            int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[copy[p1]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[p2]]);
            if (cmp >= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    offset1 = this.offsets[copy[p1]];
                    chunkIndex1 = offset1 / 0x100000;
                    chunkOffset1 = offset1 & 0xFFFFF;
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                offset2 = this.offsets[in[p2]];
                chunkIndex2 = offset2 / 0x100000;
                chunkOffset2 = offset2 & 0xFFFFF;
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingIgnoreCaseLong(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long offset1 = this.longOffsets[in[i]];
                int chunkIndex1 = (int)(offset1 / 0x100000L);
                int chunkOffset1 = (int)(offset1 & 0xFFFFFL);
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    long offset2 = this.longOffsets[in[mid]];
                    int chunkIndex2 = (int)(offset2 / 0x100000L);
                    int chunkOffset2 = (int)(offset2 & 0xFFFFFL);
                    int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[in[i]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[mid]]);
                    if (cmp >= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortAscendingIgnoreCaseLong(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingIgnoreCaseLong(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingIgnoreCaseLong(in, from, mid, nrOfThreads);
            this.mergeSortAscendingIgnoreCaseLong(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long offset1 = this.longOffsets[copy[p1]];
        int chunkIndex1 = (int)(offset1 / 0x100000L);
        int chunkOffset1 = (int)(offset1 & 0xFFFFFL);
        long offset2 = this.longOffsets[in[p2]];
        int chunkIndex2 = (int)(offset2 / 0x100000L);
        int chunkOffset2 = (int)(offset2 & 0xFFFFFL);
        for (int i = from; i < to; ++i) {
            int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[copy[p1]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[p2]]);
            if (cmp <= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    offset1 = this.longOffsets[copy[p1]];
                    chunkIndex1 = (int)(offset1 / 0x100000L);
                    chunkOffset1 = (int)(offset1 & 0xFFFFFL);
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                offset2 = this.longOffsets[in[p2]];
                chunkIndex2 = (int)(offset2 / 0x100000L);
                chunkOffset2 = (int)(offset2 & 0xFFFFFL);
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortDescendingIgnoreCaseLong(final int[] in, final int from, int to, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long offset1 = this.longOffsets[in[i]];
                int chunkIndex1 = (int)(offset1 / 0x100000L);
                int chunkOffset1 = (int)(offset1 & 0xFFFFFL);
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    long offset2 = this.longOffsets[in[mid]];
                    int chunkIndex2 = (int)(offset2 / 0x100000L);
                    int chunkOffset2 = (int)(offset2 & 0xFFFFFL);
                    int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[in[i]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[mid]]);
                    if (cmp <= 0) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    UTF8StringColumn.this.mergeSortDescendingIgnoreCaseLong(in, from, mid, nrOfThreads / 2);
                }
            });
            this.mergeSortDescendingIgnoreCaseLong(in, mid, to, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescendingIgnoreCaseLong(in, from, mid, nrOfThreads);
            this.mergeSortDescendingIgnoreCaseLong(in, mid, to, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long offset1 = this.longOffsets[copy[p1]];
        int chunkIndex1 = (int)(offset1 / 0x100000L);
        int chunkOffset1 = (int)(offset1 & 0xFFFFFL);
        long offset2 = this.longOffsets[in[p2]];
        int chunkIndex2 = (int)(offset2 / 0x100000L);
        int chunkOffset2 = (int)(offset2 & 0xFFFFFL);
        for (int i = from; i < to; ++i) {
            int cmp = UTF8Util.compareForCaseInsenstiveOrder((byte[])this.bytes[chunkIndex1], (int)chunkOffset1, (int)this.lengths[copy[p1]], (byte[])this.bytes[chunkIndex2], (int)chunkOffset2, (int)this.lengths[in[p2]]);
            if (cmp >= 0) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    offset1 = this.longOffsets[copy[p1]];
                    chunkIndex1 = (int)(offset1 / 0x100000L);
                    chunkOffset1 = (int)(offset1 & 0xFFFFFL);
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                offset2 = this.longOffsets[in[p2]];
                chunkIndex2 = (int)(offset2 / 0x100000L);
                chunkOffset2 = (int)(offset2 & 0xFFFFFL);
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }
}

