/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import com.sap.jvm.profiling.snapshot.impl.framecombiner.CalledFrameCombiner;
import com.sap.jvm.profiling.snapshot.impl.framecombiner.CombinedFrames;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CalledFilterStatisticCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<FilterEntity, V> {
    private final CalledFrameCombiner<FilterEntity> combiner;

    public CalledFilterStatisticCreator(CalledFrameCombiner<FilterEntity> combiner) {
        this.combiner = combiner;
    }

    @Override
    protected SelfAndTotalValueStatisticCollector<FilterEntity, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenEntities = new IdentityHashSet();
        while (it.next()) {
            CombinedFrames<FilterEntity> frames;
            StackFrames stack = it.getStack();
            int nrOfFrames = stack.getNrOfFrames();
            int bottom = it.getBottomRoot();
            Object value = it.getValue();
            seenEntities.clear();
            boolean addedAny = false;
            while (bottom < nrOfFrames && (frames = this.combiner.getCombinedFrames(stack, bottom, nrOfFrames)) != null) {
                bottom = frames.getEndFrame();
                addedAny = true;
                FilterEntity entity = frames.getEntity();
                if (bottom == nrOfFrames) {
                    collector.addSelf(entity, value);
                    if (!seenEntities.add((Object)entity)) break;
                    collector.addTotal(entity, value);
                    break;
                }
                if (!seenEntities.add((Object)entity)) continue;
                collector.addTotal(entity, value);
            }
            if (!addedAny) continue;
            collector.add(value);
        }
        return collector;
    }
}

