/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import com.sap.jvm.profiling.snapshot.impl.framecombiner.CalledFrameCombiner;
import com.sap.jvm.profiling.snapshot.impl.framecombiner.CombinedFrames;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalTreeCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class CalledFilterTreeCreator<V extends Value<V>>
extends SelfAndTotalTreeCreator<FilterEntity, V> {
    private final CalledFrameCombiner<FilterEntity> combiner;

    public CalledFilterTreeCreator(CalledFrameCombiner<FilterEntity> combiner) {
        this.combiner = combiner;
    }

    @Override
    protected SelfAndTotalValueTreeCollector<FilterEntity, V> getChildCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<FilterEntity, V> startNode) throws IOException {
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            CombinedFrames<FilterEntity> frames;
            StackFrames stack = it.getStack();
            int bottom = it.getBottomRoot();
            int nrOfFrames = stack.getNrOfFrames();
            Object value = it.getValue();
            SelfAndTotalValueTreeNodeImpl parent = null;
            while (bottom < nrOfFrames && (frames = this.combiner.getCombinedFrames(stack, bottom, nrOfFrames)) != null) {
                bottom = frames.getEndFrame();
                SelfAndTotalValueTreeNodeImpl currentNode = new SelfAndTotalValueTreeNodeImpl(parent, frames.getEntity(), it.getEmptyValue(), it.getEmptyValue(), false);
                currentNode = collector.getOrAdd(currentNode);
                currentNode.addTotal(value);
                if (bottom == nrOfFrames) {
                    currentNode.addSelf(value);
                } else {
                    currentNode.setHasChildren();
                }
                parent = currentNode;
            }
            collector.add(value);
        }
        return collector;
    }
}

