/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalTreeCreator;
import com.sap.jvm.profiling.snapshot.util.MethodPath;
import com.sap.jvm.profiling.snapshot.util.StackJRubyfier;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public class CalledJRubyMethodTreeCreator<V extends Value<V>>
extends SelfAndTotalTreeCreator<MethodLocation, V> {
    private static final int MAX_NODES = 50000;
    private static final int MAX_DEPTH = 50;

    @Override
    protected SelfAndTotalValueTreeCollector<MethodLocation, V> getChildCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<MethodLocation, V> startNode) throws IOException {
        int currMaxDepth = 50;
        StackFrames stack = it.getSession().getStackTraceManager().getStackFramesObject(true);
        StackJRubyfier rubyfier = new StackJRubyfier(it.getStack(), stack, it.getSession());
        MethodPath path = new MethodPath(startNode);
        int nrOfFramesToMatch = path.length();
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            int javaRoot = it.getBottomRoot();
            rubyfier.rubify(javaRoot, false, true);
            int rootOffset = rubyfier.getTopmostJRubyIndexForJavaIndex(javaRoot);
            int nrOfFrames = stack.getNrOfFrames();
            Object value = it.getValue();
            collector.add(value);
            if (!path.matches(stack, rootOffset)) continue;
            SelfAndTotalValueTreeNodeImpl<MethodLocation, V> parent = startNode;
            int depth = Math.min(currMaxDepth, nrOfFrames - rootOffset - nrOfFramesToMatch);
            for (int j = 0; j < depth; ++j) {
                int frameIndex = j + nrOfFramesToMatch + rootOffset;
                MethodLocation location = stack.getMethodLocation(frameIndex);
                SelfAndTotalValueTreeNodeImpl currentNode = new SelfAndTotalValueTreeNodeImpl(parent, location.getMethodLocationWithoutLineNr(), it.getEmptyValue(), it.getEmptyValue(), false);
                currentNode = collector.getOrAdd(currentNode);
                if (nrOfFrames > frameIndex + 1) {
                    currentNode.setHasChildren();
                }
                if (location.getLineNumber() != 0) {
                    currentNode.setHasSubNodes();
                }
                currentNode.addTotal(value);
                if (frameIndex == nrOfFrames - 1) {
                    currentNode.addSelf(value);
                }
                parent = currentNode;
            }
            if (currMaxDepth <= 1 || collector.getNrOfNodes() <= 50000) continue;
            collector.ensureMaxDepth(currMaxDepth + nrOfFramesToMatch);
            --currMaxDepth;
        }
        collector.setMaxDepth(currMaxDepth + nrOfFramesToMatch);
        return collector;
    }

    @Override
    protected SelfAndTotalValueTreeCollector<MethodLocation, V> getSubNodeCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<MethodLocation, V> startNode) throws IOException {
        StackFrames stack = it.getSession().getStackTraceManager().getStackFramesObject(true);
        StackJRubyfier rubyfier = new StackJRubyfier(it.getStack(), stack, it.getSession());
        MethodPath path = new MethodPath(startNode);
        int nrOfFramesToMatch = path.length();
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(it.getEmptyValue());
        while (it.next()) {
            int javaRoot = it.getBottomRoot();
            rubyfier.rubify(javaRoot, false, true);
            int rootOffset = rubyfier.getTopmostJRubyIndexForJavaIndex(javaRoot);
            int nrOfFrames = stack.getNrOfFrames();
            Object value = it.getValue();
            collector.add(value);
            if (!path.matches(stack, rootOffset)) continue;
            SelfAndTotalValueTreeNodeImpl<MethodLocation, V> parent = startNode;
            int frameIndex = nrOfFramesToMatch + rootOffset - 1;
            MethodLocation location = stack.getMethodLocation(frameIndex);
            if (location.getLineNumber() == 0) continue;
            SelfAndTotalValueTreeNodeImpl currentNode = new SelfAndTotalValueTreeNodeImpl(parent, location, it.getEmptyValue(), it.getEmptyValue(), true);
            currentNode = collector.getOrAdd(currentNode);
            if (nrOfFrames > frameIndex + 1) {
                currentNode.setHasChildren();
            }
            currentNode.addTotal(value);
            if (frameIndex != nrOfFrames - 1) continue;
            currentNode.addSelf(value);
        }
        collector.setMaxDepth(nrOfFramesToMatch);
        return collector;
    }
}

