/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CalledMethodStatisticByClassCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<ClassObject, V> {
    @Override
    protected SelfAndTotalValueStatisticCollector<ClassObject, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenClasses = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        ClassObject inlinedAway = it.getInlinedAwayClass();
        while (it.next()) {
            int startIndex = it.getBottomRoot();
            StackFrames stack = it.getStack();
            int nrOfFrames = stack.getNrOfFrames();
            Object value = it.getValue();
            boolean addedAny = false;
            if (it.isInlinedAwayCalled(startIndex)) {
                collector.addTotal(inlinedAway, value);
                collector.addSelf(inlinedAway, value);
                collector.add(value);
                continue;
            }
            seenClasses.clear();
            int tos = it.getTopOfStackIndex();
            for (int i = startIndex; i < nrOfFrames; ++i) {
                MethodObject method = stack.getMethod(i);
                NonArrayClassObject clazz = method.getMethodClass();
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method)) continue;
                if (seenClasses.add((Object)clazz)) {
                    collector.addTotal(clazz, value);
                    addedAny = true;
                }
                if (i < tos) continue;
                collector.addSelf(clazz, value);
                break;
            }
            if (!addedAny) continue;
            collector.add(value);
        }
        return collector;
    }
}

