/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CalledMethodStatisticByClassLoaderCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<ClassLoaderObject, V> {
    @Override
    protected SelfAndTotalValueStatisticCollector<ClassLoaderObject, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenLoaders = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        ClassLoaderObject inlinedAway = it.getInlinedAwayClassLoader();
        while (it.next()) {
            int startIndex = it.getBottomRoot();
            StackFrames stack = it.getStack();
            int nrOfFrames = stack.getNrOfFrames();
            Object value = it.getValue();
            boolean addedAny = false;
            if (it.isInlinedAwayCalled(startIndex)) {
                collector.addTotal(inlinedAway, value);
                collector.addSelf(inlinedAway, value);
                collector.add(value);
                continue;
            }
            seenLoaders.clear();
            int tos = it.getTopOfStackIndex();
            for (int i = startIndex; i < nrOfFrames; ++i) {
                MethodObject method = stack.getMethod(i);
                ClassLoaderObject loader = method.getMethodClass().getClassLoader();
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method)) continue;
                if (seenLoaders.add((Object)loader)) {
                    collector.addTotal(loader, value);
                    addedAny = true;
                }
                if (i < tos) continue;
                collector.addSelf(loader, value);
                break;
            }
            if (!addedAny) continue;
            collector.add(value);
        }
        return collector;
    }
}

