/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueTreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalTreeCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class CalledMethodStatisticByPackageTreeCreator<V extends Value<V>>
extends SelfAndTotalTreeCreator<PackageName, V> {
    @Override
    protected SelfAndTotalValueTreeCollector<PackageName, V> getChildCollector(ValueIterator<V> it, SelfAndTotalValueTreeNodeImpl<PackageName, V> startNode) throws IOException {
        assert (startNode == null);
        HashMap<UTF8String, ArrayList<SelfAndTotalValueTreeNodeImpl<PackageName, V>>> cache = new HashMap<UTF8String, ArrayList<SelfAndTotalValueTreeNodeImpl<PackageName, V>>>();
        IdentityHashSet seenPackages = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        Object empty = it.getEmptyValue();
        SelfAndTotalValueTreeCollector collector = new SelfAndTotalValueTreeCollector(empty);
        while (it.next()) {
            ArrayList nodes;
            StackFrames stack = it.getStack();
            int startIndex = it.getBottomRoot();
            int nrOfFrames = stack.getNrOfFrames();
            Object value = it.getValue();
            boolean addedAny = false;
            if (it.isInlinedAwayCalled(startIndex)) {
                nodes = this.getNodes(it.getInlinedAwayPackage(), collector, empty, cache);
                collector.add(value);
                for (SelfAndTotalValueTreeNodeImpl node : nodes) {
                    node.addSelf(value);
                    node.addTotal(value);
                }
                continue;
            }
            seenPackages.clear();
            int tos = it.getTopOfStackIndex();
            block2: for (int i = startIndex; i < nrOfFrames; ++i) {
                MethodObject method = stack.getMethod(i);
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method)) continue;
                if (!addedAny) {
                    collector.add(value);
                    addedAny = true;
                }
                PackageName packageName = method.getMethodClass().getPackage();
                nodes = this.getNodes(packageName, collector, empty, cache);
                boolean isTopOfStack = i >= tos;
                for (SelfAndTotalValueTreeNodeImpl node : nodes) {
                    if (seenPackages.add(node.getKey())) {
                        node.addTotal(value);
                    } else if (!isTopOfStack) continue block2;
                    if (!isTopOfStack) continue;
                    node.addSelf(value);
                }
            }
        }
        return collector;
    }

    public ArrayList<SelfAndTotalValueTreeNodeImpl<PackageName, V>> getNodes(PackageName name, SelfAndTotalValueTreeCollector<PackageName, V> collector, V emptyValue, HashMap<UTF8String, ArrayList<SelfAndTotalValueTreeNodeImpl<PackageName, V>>> cache) {
        ArrayList<SelfAndTotalValueTreeNodeImpl<Object, V>> nodes = cache.get(name.getName());
        if (nodes == null) {
            nodes = new ArrayList();
            ArrayList<PackageName> subPackages = new ArrayList<PackageName>();
            subPackages.add(name);
            for (PackageName parentPackage = name; parentPackage != null; parentPackage = parentPackage.getParentPackage()) {
                subPackages.add(parentPackage.asPackageWithSubPackages());
            }
            Collections.reverse(subPackages);
            SelfAndTotalValueTreeNodeImpl<PackageName, V> parent = null;
            for (PackageName subPackage : subPackages) {
                SelfAndTotalValueTreeNodeImpl<PackageName, V> currentNode = new SelfAndTotalValueTreeNodeImpl<PackageName, V>(parent, subPackage, emptyValue, emptyValue, false);
                currentNode = collector.getOrAdd(currentNode);
                if (parent != null) {
                    parent.setHasChildren();
                }
                nodes.add(currentNode);
                parent = currentNode;
            }
            Collections.reverse(nodes);
            cache.put(name.getName(), nodes);
        }
        return nodes;
    }

    @Override
    protected SelfAndTotalValueTreeNodeImpl<PackageName, V>[] convertRoots(SelfAndTotalValueTreeNodeImpl<PackageName, V>[] roots) {
        for (SelfAndTotalValueTreeNodeImpl<PackageName, V> root : roots) {
            this.convertNode(root);
        }
        return roots;
    }

    private void convertNode(SelfAndTotalValueTreeNodeImpl<PackageName, V> node) {
        if (node.hasChildren()) {
            SelfAndTotalValueTreeNodeImpl[] children = (SelfAndTotalValueTreeNodeImpl[])node.getChildren();
            PackageName name = (PackageName)node.getKey();
            if (children.length == 1 && name.getName().equals(((PackageName)children[0].getKey()).getName())) {
                node.setHasNoChildren();
            } else {
                for (SelfAndTotalValueTreeNodeImpl child : children) {
                    this.convertNode(child);
                }
            }
        }
    }
}

