/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CalledMethodStatisticCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<MethodObject, V> {
    @Override
    protected SelfAndTotalValueStatisticCollector<MethodObject, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenMethods = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        MethodObject inlinedAway = it.getInlinedAwayMethod();
        while (it.next()) {
            int start = it.getBottomRoot();
            Object value = it.getValue();
            if (it.isInlinedAwayCalled(start)) {
                collector.addTotal(inlinedAway, value);
                collector.addSelf(inlinedAway, value);
                collector.add(value);
                continue;
            }
            StackFrames stack = it.getStack();
            int end = stack.getNrOfFrames();
            int tos = it.getTopOfStackIndex();
            seenMethods.clear();
            for (int i = start; i < end; ++i) {
                MethodObject method = stack.getMethod(i);
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method)) continue;
                if (seenMethods.add((Object)method)) {
                    collector.addTotal(method, value);
                }
                if (i < tos) continue;
                collector.addSelf(method, value);
                break;
            }
            if (seenMethods.isEmpty()) continue;
            collector.add(value);
        }
        return collector;
    }
}

