/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CallingMethodStatisticByClassLoaderCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<ClassLoaderObject, V> {
    @Override
    protected SelfAndTotalValueStatisticCollector<ClassLoaderObject, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenClasses = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        ClassLoaderObject inlinedAway = it.getInlinedAwayClassLoader();
        while (it.next()) {
            StackFrames stack = it.getStack();
            int endSelf = it.getTopSelfRoot();
            int endNonSelf = it.getTopNonSelfRoot();
            int endIndex = Math.max(endSelf, endNonSelf);
            Object value = it.getValue();
            assert (endIndex >= 0);
            if (it.isInlinedAwayCalled(endIndex)) {
                collector.addTotal(inlinedAway, value);
                if (endSelf >= 0) {
                    collector.addSelf(inlinedAway, value);
                }
                collector.add(value);
                continue;
            }
            seenClasses.clear();
            boolean addedAny = false;
            for (int i = 0; i <= endIndex; ++i) {
                ClassLoaderObject loader;
                MethodObject method = stack.getMethod(i);
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method) || !seenClasses.add((Object)(loader = method.getMethodClass().getClassLoader()))) continue;
                addedAny = true;
                if (i <= endSelf) {
                    collector.addSelf(loader, value);
                }
                collector.addTotal(loader, value);
            }
            if (!addedAny) continue;
            collector.add(value);
        }
        return collector;
    }
}

