/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.creator;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;

public class CallingMethodStatisticByPackageCreator<V extends Value<V>>
extends SelfAndTotalStatisticCreator<PackageName, V> {
    @Override
    protected SelfAndTotalValueStatisticCollector<PackageName, V> getCollector(ValueIterator<V> it) throws IOException {
        SelfAndTotalValueStatisticCollector collector = new SelfAndTotalValueStatisticCollector(it.getEmptyValue());
        IdentityHashSet seenPackages = new IdentityHashSet();
        MethodFilter methodFilter = it.getMethodFilter();
        MethodFilter inlineFilter = it.getInlineFilter();
        PackageName inlinedAway = it.getInlinedAwayPackage();
        while (it.next()) {
            StackFrames stack = it.getStack();
            int endSelf = it.getTopSelfRoot();
            int endNonSelf = it.getTopNonSelfRoot();
            int endIndex = Math.max(endSelf, endNonSelf);
            Object value = it.getValue();
            assert (endIndex >= 0);
            if (it.isInlinedAwayCalled(endIndex)) {
                collector.addTotal(inlinedAway, value);
                if (endSelf >= 0) {
                    collector.addSelf(inlinedAway, value);
                }
                collector.add(value);
                continue;
            }
            seenPackages.clear();
            boolean addedAny = false;
            for (int i = 0; i <= endIndex; ++i) {
                PackageName pkg;
                MethodObject method = stack.getMethod(i);
                if (inlineFilter != null && inlineFilter.matches(method) || methodFilter != null && !methodFilter.matches(method) || !seenPackages.add((Object)(pkg = method.getMethodClass().getPackage()))) continue;
                addedAny = true;
                if (i <= endSelf) {
                    collector.addSelf(pkg, value);
                }
                collector.addTotal(pkg, value);
            }
            if (!addedAny) continue;
            collector.add(value);
        }
        return collector;
    }
}

